/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.BitSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BasePredicate;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.Predicate$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ExternalCatalogUtils$ {
    public static final ExternalCatalogUtils$ MODULE$;
    private static final String DEFAULT_PARTITION_NAME;
    private static final /* synthetic */ Tuple2 x$3;
    private static final BitSet charToEscape;
    private static final int sizeOfCharToEscape;
    private static final char[] HEX_CHARS;

    static {
        Tuple2 tuple2;
        MODULE$ = new ExternalCatalogUtils$();
        DEFAULT_PARTITION_NAME = "__HIVE_DEFAULT_PARTITION__";
        BitSet bitSet = new BitSet(128);
        char[] clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'};
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.charArrayOps(clist), (Function1 & Serializable)x$1 -> {
            bitSet.set(BoxesRunTime.unboxToChar((Object)x$1));
            return BoxedUnit.UNIT;
        });
        if (Shell.WINDOWS) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.charArrayOps(new char[]{' ', '<', '>', '|'}), (Function1 & Serializable)x$2 -> {
                bitSet.set(BoxesRunTime.unboxToChar((Object)x$2));
                return BoxedUnit.UNIT;
            });
        }
        if ((tuple2 = new Tuple2((Object)bitSet, (Object)BoxesRunTime.boxToInteger((int)bitSet.size()))) == null) {
            throw new MatchError((Object)tuple2);
        }
        BitSet charToEscape = (BitSet)tuple2._1();
        int sizeOfCharToEscape = tuple2._2$mcI$sp();
        x$3 = new Tuple2((Object)charToEscape, (Object)BoxesRunTime.boxToInteger((int)sizeOfCharToEscape));
        ExternalCatalogUtils$.charToEscape = (BitSet)x$3._1();
        ExternalCatalogUtils$.sizeOfCharToEscape = x$3._2$mcI$sp();
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
    }

    public String DEFAULT_PARTITION_NAME() {
        return DEFAULT_PARTITION_NAME;
    }

    public final BitSet charToEscape() {
        return charToEscape;
    }

    public final int sizeOfCharToEscape() {
        return sizeOfCharToEscape;
    }

    private final char[] HEX_CHARS() {
        return HEX_CHARS;
    }

    public final boolean needsEscaping(char c) {
        return c < this.sizeOfCharToEscape() && this.charToEscape().get(c);
    }

    public String escapePathName(String path) {
        int firstIndex;
        if (path == null || path.isEmpty()) {
            return path;
        }
        int length = path.length();
        for (firstIndex = 0; firstIndex < length && !this.needsEscaping(path.charAt(firstIndex)); ++firstIndex) {
        }
        if (firstIndex == length) {
            return path;
        }
        StringBuilder sb = new StringBuilder(length + 16);
        Object object = firstIndex != 0 ? sb.append(path, 0, firstIndex) : BoxedUnit.UNIT;
        while (firstIndex < length) {
            char c = path.charAt(firstIndex);
            StringBuilder stringBuilder = this.needsEscaping(c) ? sb.append('%').append(this.HEX_CHARS()[(c & 0xF0) >> 4]).append(this.HEX_CHARS()[c & 0xF]) : sb.append(c);
            ++firstIndex;
        }
        return sb.toString();
    }

    public String unescapePathName(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int plaintextEndIdx = path.indexOf(37);
        int length = path.length();
        if (plaintextEndIdx == -1 || plaintextEndIdx + 2 >= length) {
            return path;
        }
        StringBuilder sb = new StringBuilder(length);
        int plaintextStartIdx = 0;
        while (plaintextEndIdx != -1 && plaintextEndIdx + 2 < length) {
            Object object = plaintextEndIdx > plaintextStartIdx ? sb.append(path, plaintextStartIdx, plaintextEndIdx) : BoxedUnit.UNIT;
            char high = path.charAt(plaintextEndIdx + 1);
            if (high >>> 8 == 0 && Hex$.MODULE$.unhexDigits()[high] != -1) {
                char low = path.charAt(plaintextEndIdx + 2);
                if (low >>> 8 == 0 && Hex$.MODULE$.unhexDigits()[low] != -1) {
                    sb.append((char)(Hex$.MODULE$.unhexDigits()[high] << 4 | Hex$.MODULE$.unhexDigits()[low]));
                    plaintextStartIdx = plaintextEndIdx + 3;
                } else {
                    sb.append('%');
                    plaintextStartIdx = plaintextEndIdx + 1;
                }
            } else {
                sb.append('%');
                plaintextStartIdx = plaintextEndIdx + 1;
            }
            plaintextEndIdx = path.indexOf(37, plaintextStartIdx);
        }
        Object object = plaintextStartIdx < length ? sb.append(path, plaintextStartIdx, length) : BoxedUnit.UNIT;
        return sb.toString();
    }

    public Path generatePartitionPath(Map<String, String> spec, Seq<String> partitionColumnNames, Path tablePath) {
        Seq partitionPathStrings = (Seq)partitionColumnNames.map((Function1 & Serializable)col -> MODULE$.getPartitionPathString((String)col, (String)spec.apply(col)));
        return (Path)partitionPathStrings.foldLeft((Object)tablePath, (Function2 & Serializable)(totalPath, nextPartPath) -> new Path(totalPath, nextPartPath));
    }

    public String getPartitionValueString(String value) {
        if (value == null || value.isEmpty()) {
            return this.DEFAULT_PARTITION_NAME();
        }
        return this.escapePathName(value);
    }

    public String getPartitionPathString(String col, String value) {
        String partitionString = this.getPartitionValueString(value);
        return this.escapePathName(col) + "=" + partitionString;
    }

    public Seq<CatalogTablePartition> listPartitionsByFilter(SQLConf conf, SessionCatalog catalog, CatalogTable table, Seq<Expression> partitionFilters) {
        if (conf.metastorePartitionPruning()) {
            return catalog.listPartitionsByFilter(table.identifier(), partitionFilters);
        }
        return this.prunePartitionsByFilter(table, catalog.listPartitions(table.identifier(), catalog.listPartitions$default$2()), partitionFilters, conf.sessionLocalTimeZone());
    }

    public Seq<CatalogTablePartition> prunePartitionsByFilter(CatalogTable catalogTable, Seq<CatalogTablePartition> inputPartitions, Seq<Expression> predicates, String defaultTimeZoneId) {
        if (predicates.isEmpty()) {
            return inputPartitions;
        }
        StructType partitionSchema = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(catalogTable.partitionSchema());
        BasePredicate boundPredicate = this.generatePartitionPredicateByFilter(catalogTable, partitionSchema, predicates);
        return (Seq)inputPartitions.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)boundPredicate.eval(p.toRow(partitionSchema, defaultTimeZoneId))));
    }

    public BasePredicate generatePartitionPredicateByFilter(CatalogTable catalogTable, StructType partitionSchema, Seq<Expression> predicates) {
        scala.collection.immutable.Set partitionColumnNames = catalogTable.partitionColumnNames().toSet();
        Seq nonPartitionPruningPredicates = (Seq)predicates.filterNot((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogUtils$.$anonfun$generatePartitionPredicateByFilter$1(partitionColumnNames, x$4)));
        if (nonPartitionPruningPredicates.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.nonPartitionPruningPredicatesNotExpectedError((Seq<Expression>)nonPartitionPruningPredicates);
        }
        return Predicate$.MODULE$.createInterpreted((Expression)((TreeNode)predicates.reduce((Function2)And$.MODULE$)).transform(new Serializable(partitionSchema){
            private static final long serialVersionUID = 0L;
            private final StructType partitionSchema$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    int index = this.partitionSchema$2.indexWhere((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anonfun.generatePartitionPredicateByFilter.3.$anonfun$applyOrElse$1(attributeReference, x$6)));
                    return (B1)new BoundReference(index, this.partitionSchema$2.apply(index).dataType(), true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof AttributeReference;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AttributeReference x2$1, StructField x$6) {
                String string = x$6.name();
                String string2 = x2$1.name();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.partitionSchema$2 = partitionSchema$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.AttributeReference org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNullPartitionValue(String value) {
        if (value == null) return true;
        String string = value;
        String string2 = this.DEFAULT_PARTITION_NAME();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isPartialPartitionSpec(Map<String, String> spec1, Map<String, String> spec2) {
        return spec1.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogUtils$.$anonfun$isPartialPartitionSpec$1(spec2, x0$1)));
    }

    public Map<String, String> convertNullPartitionValues(Map<String, String> spec) {
        return (Map)spec.transform((Function2 & Serializable)(x$7, v) -> {
            if (v == null) {
                return MODULE$.DEFAULT_PARTITION_NAME();
            }
            return v;
        }).map((Function1 & Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x));
    }

    public static final /* synthetic */ boolean $anonfun$generatePartitionPredicateByFilter$1(scala.collection.immutable.Set partitionColumnNames$1, Expression x$4) {
        return ((IterableOnceOps)x$4.references().map((Function1 & Serializable)x$5 -> x$5.name())).toSet().subsetOf((Set)partitionColumnNames$1);
    }

    public static final /* synthetic */ boolean $anonfun$isPartialPartitionSpec$1(Map spec2$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String partitionColumn = (String)tuple2._1();
            String value = (String)tuple2._2();
            if (MODULE$.isNullPartitionValue(value)) {
                return MODULE$.isNullPartitionValue((String)spec2$1.apply((Object)partitionColumn));
            }
        }
        if (tuple2 != null) {
            String partitionColumn = (String)tuple2._1();
            String value = (String)tuple2._2();
            Object object = spec2$1.apply((Object)partitionColumn);
            String string = value;
            return !(object != null ? !object.equals(string) : string != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private ExternalCatalogUtils$() {
    }
}

