/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonObjectKeys$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.json.JsonExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(json_object) - Returns all the keys of the outermost JSON object as an array.", arguments="\n    Arguments:\n      * json_object - A JSON object. If a valid JSON object is given, all the keys of the outermost\n          object will be returned as an array. If it is any other valid JSON string, an invalid JSON\n          string or an empty string, the function returns null.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('{}');\n        []\n      > SELECT _FUNC_('{\"key\": \"value\"}');\n        [\"key\"]\n      > SELECT _FUNC_('{\"f1\":\"abc\",\"f2\":{\"f3\":\"a\", \"f4\":\"b\"}}');\n        [\"f1\",\"f2\"]\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")Q\f\u0001C!=\")!\r\u0001C!G\")q\r\u0001C!Q\")\u0011\u000f\u0001C!\u0013\")!\u000f\u0001C)g\"9a\u000fAA\u0001\n\u00039\bbB=\u0001#\u0003%\tA\u001f\u0005\n\u0003\u0017\u0001\u0011\u0011!C!\u0003\u001bA\u0011\"!\b\u0001\u0003\u0003%\t!a\b\t\u0013\u0005\u001d\u0002!!A\u0005\u0002\u0005%\u0002\"CA\u001b\u0001\u0005\u0005I\u0011IA\u001c\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00131K\u0004\n\u0003{Z\u0012\u0011!E\u0001\u0003\u007f2\u0001BG\u000e\u0002\u0002#\u0005\u0011\u0011\u0011\u0005\u0007\u001dR!\t!!'\t\u0013\u0005mE#!A\u0005F\u0005u\u0005\"CAP)\u0005\u0005I\u0011QAQ\u0011%\t)\u000bFA\u0001\n\u0003\u000b9\u000bC\u0005\u00024R\t\t\u0011\"\u0003\u00026\nq!j]8o\u001f\nTWm\u0019;LKf\u001c(B\u0001\u000f\u001e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005yy\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001IS\u0006M\u001a7yA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011!FL\u0005\u0003_m\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tQ\u0013'\u0003\u000237\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\tQC'\u0003\u000267\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"!P#\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!(\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002Eq\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0005(A\u0003dQ&dG-F\u0001K!\tQ3*\u0003\u0002M7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001+\u0015\t\u0003U\u0001AQ\u0001S\u0002A\u0002)\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005!\u0006cA\u001fV/&\u0011ak\u0012\u0002\u0004'\u0016\f\bC\u0001-\\\u001b\u0005I&B\u0001. \u0003\u0015!\u0018\u0010]3t\u0013\ta\u0016L\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001`!\tA\u0006-\u0003\u0002b3\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005!\u0007CA\u001cf\u0013\t1\u0007HA\u0004C_>dW-\u00198\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001j!\tQgN\u0004\u0002lYB\u0011q\bO\u0005\u0003[b\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q\u000eO\u0001\fe\u0016\u0004H.Y2f[\u0016tG/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003!RDQ!^\u0005A\u0002)\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Qq\"9\u0001J\u0003I\u0001\u0002\u0004Q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002w*\u0012!\n`\u0016\u0002{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000bA\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011B@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\u0007=\f\u0019\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\"A\u0019q'a\t\n\u0007\u0005\u0015\u0002HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002,\u0005E\u0002cA\u001c\u0002.%\u0019\u0011q\u0006\u001d\u0003\u0007\u0005s\u0017\u0010C\u0005\u000249\t\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000f\u0011\r\u0005m\u0012\u0011IA\u0016\u001b\t\tiDC\u0002\u0002@a\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019%!\u0010\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004I\u0006%\u0003\"CA\u001a!\u0005\u0005\t\u0019AA\u0016\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u0011q\n\u0005\n\u0003g\t\u0012\u0011!a\u0001\u0003C\ta!Z9vC2\u001cHc\u00013\u0002V!I\u00111\u0007\n\u0002\u0002\u0003\u0007\u00111\u0006\u0015\u0018\u0001\u0005e\u0013qLA1\u0003K\n9'a\u001b\u0002n\u0005E\u00141OA<\u0003s\u00022AKA.\u0013\r\tif\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019'\u0001+`\rVs5i\u0018\u0015kg>twl\u001c2kK\u000e$\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0005dG\u000e\t;iK\u0002ZW-_:!_\u001a\u0004C\u000f[3!_V$XM]7pgR\u0004#jU(OA=\u0014'.Z2uA\u0005\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA5\u0003\t]\"\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011kg>twl\u001c2kK\u000e$\b%\f\u0011BA)\u001bvJ\u0014\u0011pE*,7\r\u001e\u0018!\u0013\u001a\u0004\u0013\r\t<bY&$\u0007ES*P\u001d\u0002z'M[3di\u0002J7\u000fI4jm\u0016tG\u0006I1mY\u0002\"\b.\u001a\u0011lKf\u001c\be\u001c4!i\",\u0007e\\;uKJlwn\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002sN\u00196fGR\u0004s/\u001b7mA\t,\u0007E]3ukJtW\r\u001a\u0011bg\u0002\ng\u000eI1se\u0006Lh\u0006I%gA%$\b%[:!C:L\be\u001c;iKJ\u0004c/\u00197jI\u0002R5k\u0014(!gR\u0014\u0018N\\4-A\u0005t\u0007%\u001b8wC2LG\r\t&T\u001f:S\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011tiJLgn\u001a\u0011pe\u0002\ng\u000eI3naRL\be\u001d;sS:<G\u0006\t;iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t8vY2t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001c\u0002\u0003'S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>~O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I.^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3PI6fs\nR\u0004E\t<bYV,'%`\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u00023LI6fs\nj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|E\u0019\f$E\u000f\u0012bE\u000e\u0014CF\t43EiZ(EZ\u001a#u\t\n'\u0005\f\u0011#MR\u0012#H\t2#{v<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!7\n2\u0017G\t\u0017#MJ\u0012SL\u0003\u0011!\u0003\u00159'o\\;qC\t\t)(\u0001\u0006kg>twLZ;oGN\fQa]5oG\u0016\f#!a\u001f\u0002\u000bMr\u0013G\f\u0019\u0002\u001d)\u001bxN\\(cU\u0016\u001cGoS3zgB\u0011!\u0006F\n\u0006)\u0005\r\u0015q\u0012\t\u0007\u0003\u000b\u000bYI\u0013)\u000e\u0005\u0005\u001d%bAAEq\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003/\t!![8\n\u0007\u0019\u000b\u0019\n\u0006\u0002\u0002\u0000\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0010\u0005)\u0011\r\u001d9msR\u0019\u0001+a)\t\u000b!;\u0002\u0019\u0001&\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VAX!\u00119\u00141\u0016&\n\u0007\u00055\u0006H\u0001\u0004PaRLwN\u001c\u0005\t\u0003cC\u0012\u0011!a\u0001!\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005]\u0006\u0003BA\t\u0003sKA!a/\u0002\u0014\t1qJ\u00196fGR\u0004")
public class JsonObjectKeys
extends UnaryExpression
implements ExpectsInputTypes,
RuntimeReplaceable,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Expression> unapply(JsonObjectKeys x$0) {
        return JsonObjectKeys$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<JsonObjectKeys, A> g) {
        return JsonObjectKeys$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, JsonObjectKeys> compose(Function1<A$, Expression> g) {
        return JsonObjectKeys$.MODULE$.compose(g);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        JsonObjectKeys jsonObjectKeys = this;
        synchronized (jsonObjectKeys) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(DefaultStringProducingExpression.dataType$(this));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_object_keys";
    }

    @Override
    public Expression replacement() {
        return new StaticInvoke(JsonExpressionUtils.class, this.dataType(), "jsonObjectKeys", (Seq<Expression>)new .colon.colon((Object)this.child(), (List)Nil$.MODULE$), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
    }

    @Override
    public JsonObjectKeys withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public JsonObjectKeys copy(Expression child) {
        return new JsonObjectKeys(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "JsonObjectKeys";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonObjectKeys;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonObjectKeys)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonObjectKeys jsonObjectKeys = (JsonObjectKeys)x$1;
        Expression expression = this.child();
        Expression expression2 = jsonObjectKeys.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!jsonObjectKeys.canEqual(this)) return false;
        return true;
    }

    public JsonObjectKeys(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        RuntimeReplaceable.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        Statics.releaseFence();
    }
}

