/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000by\u0003A\u0011I0\t\u0011\r\u0004\u0001R1A\u0005\u0006\u0011DQ\u0001\u0017\u0001\u0005\u0002!DQa\u001b\u0001\u0005B1DQA\u001e\u0001\u0005B]Dq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\r\u0005-\u0002\u0001\"\u0011P\u0011\u0019\ti\u0003\u0001C!\u001f\"1\u0011q\u0006\u0001\u0005B=Cq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002F\u0001!\t&a\u0012\t\u0013\u0005U\u0003!!A\u0005\u0002\u0005]\u0003\"CA0\u0001E\u0005I\u0011AA1\u0011%\t9\bAI\u0001\n\u0003\t\t\u0007C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002b!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\t\u0003\u001b\u0003\u0011\u0011!C\u0001I\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003/\u0003\u0011\u0011!C!\u00033C\u0011\"a*\u0001\u0003\u0003%\t!!+\t\u0013\u00055\u0006!!A\u0005B\u0005=\u0006\"CAZ\u0001\u0005\u0005I\u0011IA[\u000f%\tynJA\u0001\u0012\u0003\t\tO\u0002\u0005'O\u0005\u0005\t\u0012AAr\u0011\u0019A\u0006\u0005\"\u0001\u0002|\"I\u0011Q \u0011\u0002\u0002\u0013\u0015\u0013q \u0005\n\u0005\u0003\u0001\u0013\u0011!CA\u0005\u0007A\u0011Ba\u0003!\u0003\u0003%\tI!\u0004\t\u0013\t}\u0001%!A\u0005\n\t\u0005\"!D*ue&twMU3qY\u0006\u001cWM\u0003\u0002)S\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tQ3&\u0001\u0005dCR\fG._:u\u0015\taS&A\u0002tc2T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001'\u0015\u0001Q'\u000f\u001fC!\t1t'D\u0001(\u0013\tAtEA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\u000e\u001e\n\u0005m:#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000fA\u0013x\u000eZ;diB\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!aR\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014B\u0001&?\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005)s\u0014aB:sG\u0016C\bO]\u000b\u0002!B\u0011a'U\u0005\u0003%\u001e\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0019(oY#yaJ\u0004\u0013AC:fCJ\u001c\u0007.\u0012=qe\u0006Y1/Z1sG\",\u0005\u0010\u001d:!\u0003-\u0011X\r\u001d7bG\u0016,\u0005\u0010\u001d:\u0002\u0019I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0011\u0002\rqJg.\u001b;?)\u0011Q6\fX/\u0011\u0005Y\u0002\u0001\"\u0002(\b\u0001\u0004\u0001\u0006\"\u0002+\b\u0001\u0004\u0001\u0006\"\u0002,\b\u0001\u0004\u0001\u0016A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002AB\u0011Q(Y\u0005\u0003Ez\u0012qAQ8pY\u0016\fg.A\u0006d_2d\u0017\r^5p]&#W#A3\u0011\u0005u2\u0017BA4?\u0005\rIe\u000e\u001e\u000b\u00045&T\u0007\"\u0002(\u000b\u0001\u0004\u0001\u0006\"\u0002+\u000b\u0001\u0004\u0001\u0016\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003B7qeR\u0004\"!\u00108\n\u0005=t$aA!os\")\u0011o\u0003a\u0001[\u000691O]2Fm\u0006d\u0007\"B:\f\u0001\u0004i\u0017AC:fCJ\u001c\u0007.\u0012<bY\")Qo\u0003a\u0001[\u0006Y!/\u001a9mC\u000e,WI^1m\u0003%!wnR3o\u0007>$W\r\u0006\u0003y}\u0006\u001d\u0001CA=}\u001b\u0005Q(BA>(\u0003\u001d\u0019w\u000eZ3hK:L!! >\u0003\u0011\u0015C\bO]\"pI\u0016Daa \u0007A\u0002\u0005\u0005\u0011aA2uqB\u0019\u00110a\u0001\n\u0007\u0005\u0015!P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005%A\u00021\u0001y\u0003\t)g/\u0001\u0005eCR\fG+\u001f9f+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bK\u0001\u0006if\u0004Xm]\u0005\u0005\u00033\t\u0019B\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003?\u0001RaQA\u0011\u0003KI1!a\tN\u0005\r\u0019V-\u001d\t\u0005\u0003#\t9#\u0003\u0003\u0002*\u0005M!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u007fqA!!\u000f\u0002<A\u0011QIP\u0005\u0004\u0003{q\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0005\r#AB*ue&twMC\u0002\u0002>y\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000fi\u000bI%!\u0014\u0002R!1\u00111J\nA\u0002A\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0003\u001f\u001a\u0002\u0019\u0001)\u0002\u00139,woU3d_:$\u0007BBA*'\u0001\u0007\u0001+\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000fi\u000bI&a\u0017\u0002^!9a\n\u0006I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0015!\u0003\u0005\r\u0001\u0015\u0005\b-R\u0001\n\u00111\u0001Q\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0019+\u0007A\u000b)g\u000b\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014!C;oG\",7m[3e\u0015\r\t\tHP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA;\u0003W\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u007f\u0002B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)\u0001\u0003mC:<'BAAE\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u00131Q\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ri\u00171\u0013\u0005\t\u0003+S\u0012\u0011!a\u0001K\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a'\u0011\u000b\u0005u\u00151U7\u000e\u0005\u0005}%bAAQ}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0016q\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002a\u0003WC\u0001\"!&\u001d\u0003\u0003\u0005\r!\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0000\u0005E\u0006\u0002CAK;\u0005\u0005\t\u0019A3\u0002\r\u0015\fX/\u00197t)\r\u0001\u0017q\u0017\u0005\t\u0003+s\u0012\u0011!a\u0001[\":\u0002!a/\u0002B\u0006\r\u0017qYAe\u0003\u001b\fy-a5\u0002V\u0006e\u00171\u001c\t\u0004m\u0005u\u0016bAA`O\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAc\u0003U{f)\u0016(D?\"\u001aHO\u001d\u0017!g\u0016\f'o\u00195\\Y\u0001\u0012X\r\u001d7bG\u0016l\u0016\u0006I\u0017!%\u0016\u0004H.Y2fg\u0002\nG\u000e\u001c\u0011pG\u000e,(O]3oG\u0016\u001c\be\u001c4!AN,\u0017M]2iA\u0002:\u0018\u000e\u001e5!AJ,\u0007\u000f\\1dK\u0002t\u0013!C1sOVlWM\u001c;tC\t\tY-\u0001B9\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aX-\u0019:dQ\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:t\u0003%\u00134!AN,\u0017M]2iA\u0002J7\u000f\t8pi\u00022w.\u001e8eA%t\u0007\u0005Y:ue\u0002d\u0003\u0005Y:ue\u0002\u0004\u0013n\u001d\u0011sKR,(O\\3eAUt7\r[1oO\u0016$gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sKBd\u0017mY3![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001Je\r\t1sKBd\u0017mY3aA%\u001c\bE\\8uAM\u0004XmY5gS\u0016$\u0007e\u001c:!SN\u0004\u0013M\u001c\u0011f[B$\u0018\u0010I:ue&tw\r\f\u0011o_RD\u0017N\\4!e\u0016\u0004H.Y2fg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;iK\u0002\u001aHO]5oO\u0002\"\b.\u0019;!SN\u0004#/Z7pm\u0016$\u0007E\u001a:p[\u0002\u00027\u000f\u001e:a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t.\u0001(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n%iQ1cG\u001eb\u0003eJ1cG\u001eb\u0003e\n#F\r\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!C\u0007\u0012+eI\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t9.A\u00033]Mr\u0003'A\u0003he>,\b/\t\u0002\u0002^\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006i1\u000b\u001e:j]\u001e\u0014V\r\u001d7bG\u0016\u0004\"A\u000e\u0011\u0014\u000b\u0001\n)/!=\u0011\u0011\u0005\u001d\u0018Q\u001e)Q!jk!!!;\u000b\u0007\u0005-h(A\u0004sk:$\u0018.\\3\n\t\u0005=\u0018\u0011\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BAz\u0003sl!!!>\u000b\t\u0005]\u0018qQ\u0001\u0003S>L1\u0001TA{)\t\t\t/\u0001\u0005u_N#(/\u001b8h)\t\ty(A\u0003baBd\u0017\u0010F\u0004[\u0005\u000b\u00119A!\u0003\t\u000b9\u001b\u0003\u0019\u0001)\t\u000bQ\u001b\u0003\u0019\u0001)\t\u000bY\u001b\u0003\u0019\u0001)\u0002\u000fUt\u0017\r\u001d9msR!!q\u0002B\u000e!\u0015i$\u0011\u0003B\u000b\u0013\r\u0011\u0019B\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ru\u00129\u0002\u0015)Q\u0013\r\u0011IB\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tuA%!AA\u0002i\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u0003\u0005\u0003\u0002\u0002\n\u0015\u0012\u0002\u0002B\u0014\u0003\u0007\u0013aa\u00142kK\u000e$\b")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace x$0) {
        return StringReplace$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        StringReplace stringReplace = this;
        synchronized (stringReplace) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return CollationSupport.StringReplace.exec((UTF8String)((UTF8String)srcEval), (UTF8String)((UTF8String)searchEval), (UTF8String)((UTF8String)replaceEval), (int)this.collationId());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(src, search, replace) -> CollationSupport.StringReplace.genCode((String)src, (String)search, (String)replace, (int)this.collationId()));
    }

    @Override
    public DataType dataType() {
        return this.srcExpr().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.srcExpr();
    }

    @Override
    public Expression second() {
        return this.searchExpr();
    }

    @Override
    public Expression third() {
        return this.replaceExpr();
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    @Override
    public StringReplace withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcExpr();
            }
            case 1: {
                return this.searchExpr();
            }
            case 2: {
                return this.replaceExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcExpr";
            }
            case 1: {
                return "searchExpr";
            }
            case 2: {
                return "replaceExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

