/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.evaluation.ClusteringEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;

public final class KMeansExample$ {
    public static final KMeansExample$ MODULE$ = new KMeansExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(String.valueOf(this.getClass().getSimpleName())).getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_kmeans_data.txt");
        KMeans kmeans = new KMeans().setK(2).setSeed(1L);
        KMeansModel model = kmeans.fit(dataset);
        Dataset predictions = model.transform(dataset);
        ClusteringEvaluator evaluator = new ClusteringEvaluator();
        double silhouette = evaluator.evaluate(predictions);
        Predef$.MODULE$.println((Object)("Silhouette with squared euclidean distance = " + silhouette));
        Predef$.MODULE$.println((Object)"Cluster Centers: ");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()), (Function1 & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    private KMeansExample$() {
    }
}

