/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.utils;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.SparkSQLException$;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.CompressionCodec;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.planner.InvalidInputErrors$;
import org.sparkproject.connect.protobuf.ByteString;
import org.sparkproject.connect.protobuf.CodedInputStream;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class PlanCompressionUtils$ {
    public static final PlanCompressionUtils$ MODULE$ = new PlanCompressionUtils$();

    public Plan decompressPlan(Plan plan) {
        Plan.OpTypeCase opTypeCase = plan.getOpTypeCase();
        if (Plan.OpTypeCase.COMPRESSED_OPERATION.equals(opTypeCase)) {
            Plan plan2;
            Function0 closeStream;
            block16: {
                Tuple2<CodedInputStream, Function0<BoxedUnit>> tuple2 = this.decompressBytes(plan.getCompressedOperation().getData(), plan.getCompressedOperation().getCompressionCodec());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CodedInputStream cis = (CodedInputStream)tuple2._1();
                Function0 closeStream2 = (Function0)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)cis, (Object)closeStream2);
                CodedInputStream cis2 = (CodedInputStream)tuple22._1();
                closeStream = (Function0)tuple22._2();
                try {
                    try {
                        Plan.CompressedOperation.OpType opType = plan.getCompressedOperation().getOpType();
                        if (Plan.CompressedOperation.OpType.OP_TYPE_RELATION.equals(opType)) {
                            plan2 = Plan.newBuilder().setRoot(Relation.parser().parseFrom(cis2)).build();
                            break block16;
                        }
                        if (Plan.CompressedOperation.OpType.OP_TYPE_COMMAND.equals(opType)) {
                            plan2 = Plan.newBuilder().setCommand(Command.parser().parseFrom(cis2)).build();
                            break block16;
                        }
                        throw InvalidInputErrors$.MODULE$.invalidOneOfField(opType, plan.getCompressedOperation().getDescriptorForType());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 instanceof SparkSQLException) {
                            SparkSQLException sparkSQLException = (SparkSQLException)throwable3;
                            throw sparkSQLException;
                        }
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            throw new SparkSQLException("CONNECT_INVALID_PLAN.CANNOT_PARSE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"errorMsg"), (Object)throwable2.getMessage())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        try {
                            closeStream.apply$mcV$sp();
                        }
                        catch (Throwable throwable4) {
                            Option option;
                            Throwable throwable5 = throwable4;
                            if (throwable5 != null && !(option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                                break block17;
                            }
                            throw throwable4;
                        }
                    }
                    throw throwable;
                }
            }
            Plan plan3 = plan2;
            try {
                closeStream.apply$mcV$sp();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable6 = throwable;
                if (throwable6 != null && !(option = NonFatal$.MODULE$.unapply(throwable6)).isEmpty()) {
                }
                throw throwable;
            }
            return plan3;
        }
        return plan;
    }

    private long getMaxPlanSize() {
        return BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_MAX_PLAN_SIZE()));
    }

    private Tuple2<CodedInputStream, Function0<BoxedUnit>> decompressBytes(ByteString data, CompressionCodec compressionCodec) {
        CompressionCodec compressionCodec2 = compressionCodec;
        if (CompressionCodec.COMPRESSION_CODEC_ZSTD.equals(compressionCodec2)) {
            return this.decompressBytesWithZstd(data, this.getMaxPlanSize());
        }
        throw InvalidInputErrors$.MODULE$.invalidEnum(compressionCodec2);
    }

    private Tuple2<CodedInputStream, Function0<BoxedUnit>> decompressBytesWithZstd(ByteString input, long maxOutputSize) {
        long declaredSize = Zstd.getFrameContentSize((ByteBuffer)input.asReadOnlyByteBuffer());
        if (declaredSize > maxOutputSize) {
            throw new SparkSQLException("CONNECT_INVALID_PLAN.PLAN_SIZE_LARGER_THAN_MAX", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"planSize"), (Object)Long.toString(declaredSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPlanSize"), (Object)Long.toString(maxOutputSize))})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
        ZstdInputStreamNoFinalizer zstdStream = new ZstdInputStreamNoFinalizer(input.newInput());
        BoundedInputStream boundedStream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)zstdStream)).setMaxCount(maxOutputSize)).setOnMaxCount((x$2, x$3) -> {
            throw new SparkSQLException("CONNECT_INVALID_PLAN.PLAN_SIZE_LARGER_THAN_MAX", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"planSize"), (Object)"unknown"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPlanSize"), (Object)Long.toString(maxOutputSize))})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        })).get();
        CodedInputStream cis = CodedInputStream.newInstance((InputStream)boundedStream);
        cis.setSizeLimit(Integer.MAX_VALUE);
        cis.setRecursionLimit(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_MARSHALLER_RECURSION_LIMIT())));
        return new Tuple2((Object)cis, (JFunction0.mcV.sp & Serializable)() -> boundedStream.close());
    }

    private PlanCompressionUtils$() {
    }
}

