/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DDLUtils$
implements Logging {
    public static final DDLUtils$ MODULE$ = new DDLUtils$();
    private static final String HIVE_PROVIDER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        HIVE_PROVIDER = "hive";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String HIVE_PROVIDER() {
        return HIVE_PROVIDER;
    }

    public boolean isHiveTable(CatalogTable table) {
        return this.isHiveTable((Option<String>)table.provider());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHiveTable(Option<String> provider) {
        if (!provider.isDefined()) return false;
        String string = ((String)provider.get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        if (!table.provider().isDefined()) return false;
        String string = ((String)table.provider().get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public HiveTableRelation readHiveTable(CatalogTable table) {
        return new HiveTableRelation(table, DataTypeUtils$.MODULE$.toAttributes(table.dataSchema().asNullable()), DataTypeUtils$.MODULE$.toAttributes(table.partitionSchema().asNullable()), HiveTableRelation$.MODULE$.apply$default$4(), HiveTableRelation$.MODULE$.apply$default$5());
    }

    public void verifyPartitionProviderIsHive(SparkSession spark, CatalogTable table, String action) {
        String tableName = table.identifier().table();
        if (!spark.sessionState().conf().manageFilesourcePartitions() && this.isDatasourceTable(table)) {
            throw QueryCompilationErrors$.MODULE$.actionNotAllowedOnTableWithFilesourcePartitionManagementDisabledError(action, tableName);
        }
        if (!table.tracksPartitionsInCatalog() && this.isDatasourceTable(table)) {
            throw QueryCompilationErrors$.MODULE$.actionNotAllowedOnTableSincePartitionMetadataNotStoredError(action, tableName);
        }
    }

    public void verifyAlterTableType(SessionCatalog catalog, CatalogTable tableMetadata, boolean isView) {
        if (!catalog.isTempView(tableMetadata.identifier())) {
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !isView) {
                throw QueryCompilationErrors$.MODULE$.cannotAlterViewWithAlterTableError(tableMetadata.identifier().table());
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && isView) {
                throw QueryCompilationErrors$.MODULE$.cannotAlterTableWithAlterViewError(tableMetadata.identifier().table());
            }
            return;
        }
    }

    public void checkTableColumns(CatalogTable table) {
        this.checkTableColumns(table, table.dataSchema());
    }

    public void checkTableColumns(CatalogTable table, StructType schema) {
        table.provider().foreach((Function1 & Serializable)x$10 -> {
            DDLUtils$.$anonfun$checkTableColumns$1(table, schema, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public void checkDataColNames(String provider, StructType schema) {
        Object source;
        Object obj;
        try {
            obj = DataSource$.MODULE$.lookupDataSource(provider, SQLConf$.MODULE$.get()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find data source: ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.DATA_SOURCE, provider)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"when check data column names."}))).log((Seq)Nil$.MODULE$))), e);
            return;
        }
        Object obj2 = source = obj;
        if (obj2 instanceof FileFormat) {
            FileFormat fileFormat = (FileFormat)obj2;
            DataSourceUtils$.MODULE$.checkFieldNames(fileFormat, schema);
            return;
        }
        if (obj2 instanceof FileDataSourceV2) {
            FileDataSourceV2 fileDataSourceV2 = (FileDataSourceV2)obj2;
            DataSourceUtils$.MODULE$.checkFieldNames(fileDataSourceV2.fallbackFileFormat().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), schema);
            return;
        }
    }

    public void verifyNotReadPath(LogicalPlan query, Path outputPath, Option<CatalogTable> table) {
        Seq inputPaths = (Seq)query.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BaseRelation r;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)A1)).isEmpty() && (r = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)r;
                    return (B1)hadoopFsRelation.location().rootPaths();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                BaseRelation r;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan2)).isEmpty() && (r = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation;
            }
        }).flatten(Predef$.MODULE$.$conforms());
        if (inputPaths.contains((Object)outputPath)) {
            Option<CatalogTable> option = table;
            if (option instanceof Some) {
                Some some = (Some)option;
                CatalogTable v = (CatalogTable)some.value();
                throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(v.identifier());
            }
            throw QueryCompilationErrors$.MODULE$.cannotOverwritePathBeingReadFromError(outputPath.toString());
        }
    }

    public Option<CatalogTable> verifyNotReadPath$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$checkTableColumns$2(StructField x$11) {
        return x$11.dataType() instanceof AnsiIntervalType;
    }

    public static final /* synthetic */ void $anonfun$checkTableColumns$1(CatalogTable table$6, StructType schema$2, String x$10) {
        String string;
        block9: {
            Option serde;
            block11: {
                block10: {
                    string = x$10.toLowerCase(Locale.ROOT);
                    String string2 = MODULE$.HIVE_PROVIDER();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block9;
                    serde = table$6.storage().serde();
                    if (schema$2.exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DDLUtils$.$anonfun$checkTableColumns$2(x$11)))) {
                        throw QueryExecutionErrors$.MODULE$.hiveTableWithAnsiIntervalsError(table$6.identifier());
                    }
                    Option option = serde;
                    Option<String> option2 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("orc").get()).serde();
                    if (!(option != null ? !option.equals(option2) : option2 != null)) {
                        MODULE$.checkDataColNames("orc", schema$2);
                        return;
                    }
                    Option option3 = serde;
                    Option<String> option4 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("parquet").get()).serde();
                    if (!(option3 == null ? option4 != null : !option3.equals(option4))) break block10;
                    Option option5 = serde;
                    Some some = new Some((Object)"parquet.hive.serde.ParquetHiveSerDe");
                    if (!(option5 == null ? some != null : !option5.equals(some))) break block10;
                    Option option6 = serde;
                    Some some2 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
                    if (option6 != null ? !option6.equals(some2) : some2 != null) break block11;
                }
                MODULE$.checkDataColNames("parquet", schema$2);
                return;
            }
            Option option = serde;
            Option<String> option7 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("avro").get()).serde();
            if (!(option != null ? !option.equals(option7) : option7 != null)) {
                MODULE$.checkDataColNames("avro", schema$2);
                return;
            }
            return;
        }
        if ("parquet".equals(string)) {
            MODULE$.checkDataColNames("parquet", schema$2);
            return;
        }
        if ("orc".equals(string)) {
            MODULE$.checkDataColNames("orc", schema$2);
            return;
        }
        if ("avro".equals(string)) {
            MODULE$.checkDataColNames("avro", schema$2);
            return;
        }
    }

    private DDLUtils$() {
    }
}

