/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1.sql;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.util.Date;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore$;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SparkPlanGraph;
import org.apache.spark.sql.execution.ui.SparkPlanGraphCluster;
import org.apache.spark.sql.execution.ui.SparkPlanGraphEdge;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.status.api.v1.sql.ExecutionData;
import org.apache.spark.status.api.v1.sql.Metric;
import org.apache.spark.status.api.v1.sql.Metric$;
import org.apache.spark.status.api.v1.sql.Node;
import org.apache.spark.status.api.v1.sql.Node$;
import org.apache.spark.ui.SparkUI;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f!\u0002\u0006\f\u00015I\u0002\"\u0002\u0013\u0001\t\u00031\u0003bB\u0015\u0001\u0005\u0004%\tA\u000b\u0005\u0007g\u0001\u0001\u000b\u0011B\u0016\t\u000bQ\u0002A\u0011A\u001b\t\u000b1\u0001A\u0011A<\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003\u001f\u0003A\u0011BAI\u0005-\u0019\u0016\u000f\u001c*fg>,(oY3\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0003mFR!\u0001E\t\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0013'\u000511\u000f^1ukNT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"E5\tQ\"\u0003\u0002$\u001b\ty!)Y:f\u0003B\u0004(+Z:pkJ\u001cW-\u0001\u0004=S:LGOP\u0002\u0001)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005Y\u0011aE,I\u001f2+ul\u0015+B\u000f\u0016{6i\u0014#F\u000f\u0016sU#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t11\u000b\u001e:j]\u001e\fAc\u0016%P\u0019\u0016{6\u000bV!H\u000b~\u001bu\nR#H\u000b:\u0003\u0013aB:rY2K7\u000f\u001e\u000b\u0006m\u0015k&\r\u001c\t\u0004o}\u0012eB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYT%\u0001\u0004=e>|GOP\u0005\u0002;%\u0011a\bH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015IA\u0002TKFT!A\u0010\u000f\u0011\u0005!\u001a\u0015B\u0001#\f\u00055)\u00050Z2vi&|g\u000eR1uC\")a\t\u0002a\u0001\u000f\u00069A-\u001a;bS2\u001c\bCA\u000eI\u0013\tIEDA\u0004C_>dW-\u00198)\t\u0015[UK\u0016\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000b!A]:\u000b\u0005A\u000b\u0016AA<t\u0015\u0005\u0011\u0016a\u00026bW\u0006\u0014H/Y\u0005\u0003)6\u0013A\u0002R3gCVdGOV1mk\u0016\fQA^1mk\u0016\f\u0013aV\u0001\u0005iJ,X\r\u000b\u0003F3Vc\u0006C\u0001'[\u0013\tYVJ\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\f\u0013A\u0012\u0005\u0006=\u0012\u0001\raR\u0001\u0010a2\fg\u000eR3tGJL\u0007\u000f^5p]\"\"QlS+WQ\u0011i\u0016,V1\"\u0003yCQa\u0019\u0003A\u0002\u0011\faa\u001c4gg\u0016$\bCA\u000ef\u0013\t1GDA\u0002J]RDCAY&VQ\u0006\n\u0011.A\u00011Q\u0011\u0011\u0017,V6\"\u0003\rDQ!\u001c\u0003A\u0002\u0011\fa\u0001\\3oORD\u0007\u0006\u00027L+>\f\u0013\u0001]\u0001\u0003eABC\u0001\\-Ve\u0006\nQ\u000e\u000b\u0002\u0005iB\u0011A*^\u0005\u0003m6\u00131aR#U)\u0019\u0011\u00050a\u0002\u0002\u000e!)\u00110\u0002a\u0001u\u00061Q\r_3d\u0013\u0012\u0004\"aG>\n\u0005qd\"\u0001\u0002'p]\u001eDS\u0001\u001f@V\u0003\u0007\u0001\"\u0001T@\n\u0007\u0005\u0005QJA\u0005QCRD\u0007+\u0019:b[\u0006\u0012\u0011QA\u0001\fKb,7-\u001e;j_:LE\rC\u0003G\u000b\u0001\u0007q\tK\u0003\u0002\b-+f\u000bK\u0003\u0002\be+F\fC\u0003_\u000b\u0001\u0007q\tK\u0003\u0002\u000e-+f\u000bK\u0003\u0002\u000ee+\u0016\r\u000b\u0002\u0006i\"2Q!a\u0006V\u0003;\u00012\u0001TA\r\u0013\r\tY\"\u0014\u0002\u0005!\u0006$\b.\t\u0002\u0002 \u0005\t20\u001a=fGV$\u0018n\u001c8JIjbFmK?\u0002)A\u0014X\r]1sK\u0016CXmY;uS>tG)\u0019;b)%\u0011\u0015QEA\u001e\u0003\u000b\n9\u0005C\u0004\u0002(\u0019\u0001\r!!\u000b\u0002\t\u0015DXm\u0019\t\u0005\u0003W\t9$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\t)\u0018N\u0003\u0003\u00024\u0005U\u0012!C3yK\u000e,H/[8o\u0015\ta1#\u0003\u0003\u0002:\u00055\"AE*R\u0019\u0016CXmY;uS>tW+\u0013#bi\u0006Dq!!\u0010\u0007\u0001\u0004\ty$A\u0003he\u0006\u0004\b\u000e\u0005\u0003\u0002,\u0005\u0005\u0013\u0002BA\"\u0003[\u0011ab\u00159be.\u0004F.\u00198He\u0006\u0004\b\u000eC\u0003G\r\u0001\u0007q\tC\u0003_\r\u0001\u0007q)\u0001\tqe&tG/\u00192mK6+GO]5dgR1\u0011QJA/\u0003S\u0002b!a\u0014\u0002V\u0005]SBAA)\u0015\r\t\u0019\u0006H\u0001\u000bG>dG.Z2uS>t\u0017b\u0001!\u0002RA\u0019\u0001&!\u0017\n\u0007\u0005m3B\u0001\u0003O_\u0012,\u0007bBA0\u000f\u0001\u0007\u0011\u0011M\u0001\tC2dgj\u001c3fgB1\u0011qJA+\u0003G\u0002B!a\u000b\u0002f%!\u0011qMA\u0017\u0005I\u0019\u0006/\u0019:l!2\fgn\u0012:ba\"tu\u000eZ3\t\u000f\u0005-t\u00011\u0001\u0002n\u0005aQ.\u001a;sS\u000e4\u0016\r\\;fgB9\u0011qNA<u\u0006ud\u0002BA9\u0003g\u0002\"!\u000f\u000f\n\u0007\u0005UD$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\nYHA\u0002NCBT1!!\u001e\u001d!\u0011\ty'a \n\u0007I\nY(A\u000bhKRtu\u000eZ3JI\u0006sGmV*D\u000f&#W*\u00199\u0015\t\u0005\u0015\u0015Q\u0012\t\b\u0003_\n9H_AD!\u0011Y\u0012\u0011\u0012>\n\u0007\u0005-ED\u0001\u0004PaRLwN\u001c\u0005\b\u0003?B\u0001\u0019AA1\u0003Y9W\r^,i_2,7\u000b^1hK\u000e{G-Z4f]&#G\u0003BAD\u0003'Cq!!&\n\u0001\u0004\ti(\u0001\u0007xg\u000e<gj\u001c3f\u001d\u0006lW\r\u000b\u0004\u0001\u00033+\u0016q\u0014\t\u0004\u0019\u0006m\u0015bAAO\u001b\nA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002\"\u0006\u0012\u00111U\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:\u0004")
public class SqlResource
implements BaseAppResource {
    private final String WHOLE_STAGE_CODEGEN;
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$((BaseAppResource)this, fn);
    }

    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$((BaseAppResource)this);
    }

    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$((ApiRequestContext)this);
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    public String WHOLE_STAGE_CODEGEN() {
        return this.WHOLE_STAGE_CODEGEN;
    }

    @GET
    public scala.collection.immutable.Seq<ExecutionData> sqlList(@DefaultValue(value="true") @QueryParam(value="details") boolean details, @DefaultValue(value="true") @QueryParam(value="planDescription") boolean planDescription, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length) {
        return (scala.collection.immutable.Seq)this.withUI((Function1 & Serializable)ui -> {
            SQLAppStatusStore sqlStore = new SQLAppStatusStore(ui.store().store(), SQLAppStatusStore$.MODULE$.$lessinit$greater$default$2());
            return (scala.collection.immutable.Seq)sqlStore.executionsList(offset, length).map((Function1 & Serializable)exec -> {
                SparkPlanGraph graph = sqlStore.planGraph(exec.executionId());
                return this.prepareExecutionData((SQLExecutionUIData)exec, graph, details, planDescription);
            });
        });
    }

    @GET
    @Path(value="{executionId:\\d+}")
    public ExecutionData sql(@PathParam(value="executionId") long execId, @DefaultValue(value="true") @QueryParam(value="details") boolean details, @DefaultValue(value="true") @QueryParam(value="planDescription") boolean planDescription) {
        return (ExecutionData)this.withUI((Function1 & Serializable)ui -> {
            SQLAppStatusStore sqlStore = new SQLAppStatusStore(ui.store().store(), SQLAppStatusStore$.MODULE$.$lessinit$greater$default$2());
            return (ExecutionData)sqlStore.execution(execId).map((Function1 & Serializable)x$1 -> this.prepareExecutionData((SQLExecutionUIData)x$1, sqlStore.planGraph(execId), details, planDescription)).getOrElse((Function0 & Serializable)() -> {
                throw new NotFoundException("unknown query execution id: " + execId);
            });
        });
    }

    private ExecutionData prepareExecutionData(SQLExecutionUIData exec, SparkPlanGraph graph, boolean details, boolean planDescription) {
        ObjectRef running = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
        ObjectRef completed = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
        ObjectRef failed = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
        exec.jobs().foreach((Function1 & Serializable)x0$1 -> {
            SqlResource.$anonfun$prepareExecutionData$1(running, completed, failed, x0$1);
            return BoxedUnit.UNIT;
        });
        long duration = ((Date)exec.completionTime().getOrElse((Function0 & Serializable)() -> new Date())).getTime() - exec.submissionTime();
        String planDetails = planDescription ? exec.physicalPlanDescription() : "";
        Seq<Node> nodes = details ? this.printableMetrics(graph.allNodes(), (Map<Object, String>)((Map)Option$.MODULE$.apply(exec.metricValues()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))) : (Seq<Node>)package$.MODULE$.Seq().empty();
        Seq edges = details ? graph.edges() : (Seq)package$.MODULE$.Seq().empty();
        return new ExecutionData(exec.executionId(), exec.executionStatus(), exec.description(), planDetails, new Date(exec.submissionTime()), duration, (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)running.elem), (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)completed.elem), (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)failed.elem), nodes, (Seq<SparkPlanGraphEdge>)edges);
    }

    private Seq<Node> printableMetrics(Seq<SparkPlanGraphNode> allNodes, Map<Object, String> metricValues) {
        Map<Object, Option<Object>> nodeIdAndWSCGIdMap = this.getNodeIdAndWSCGIdMap(allNodes);
        Seq nodes = (Seq)allNodes.map((Function1 & Serializable)node -> {
            Option wholeStageCodegenId = nodeIdAndWSCGIdMap.get((Object)BoxesRunTime.boxToLong((long)node.id())).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Seq metrics = (Seq)node.metrics().flatMap((Function1 & Serializable)m -> SqlResource.getMetric$1(metricValues, m.accumulatorId(), m.name().trim()));
            return Node$.MODULE$.apply(node.id(), node.name().trim(), (Option<Object>)wholeStageCodegenId, (Seq<Metric>)metrics);
        });
        return (Seq)((SeqOps)nodes.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.nodeId()), (Ordering)Ordering.Long$.MODULE$)).reverse();
    }

    private Map<Object, Option<Object>> getNodeIdAndWSCGIdMap(Seq<SparkPlanGraphNode> allNodes) {
        Seq wscgNodes = (Seq)allNodes.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlResource.$anonfun$getNodeIdAndWSCGIdMap$1(this, x$3)));
        Map nodeIdAndWSCGIdMap = ((IterableOnceOps)wscgNodes.flatMap((Function1 & Serializable)x$4 -> {
            SparkPlanGraphNode sparkPlanGraphNode = x$4;
            if (sparkPlanGraphNode instanceof SparkPlanGraphCluster) {
                SparkPlanGraphCluster sparkPlanGraphCluster = (SparkPlanGraphCluster)sparkPlanGraphNode;
                return (Seq)sparkPlanGraphCluster.nodes().map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)x$5.id())), this.getWholeStageCodegenId(sparkPlanGraphCluster.name().trim())));
            }
            return (Seq)package$.MODULE$.Seq().empty();
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return nodeIdAndWSCGIdMap;
    }

    private Option<Object> getWholeStageCodegenId(String wscgNodeName) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(wscgNodeName.substring((this.WHOLE_STAGE_CODEGEN() + " (").length(), wscgNodeName.length() - 1))));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            long wscgId = BoxesRunTime.unboxToLong((Object)success.value());
            return new Some((Object)BoxesRunTime.boxToLong((long)wscgId));
        }
        if (try_ instanceof Failure) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$prepareExecutionData$1(ObjectRef running$1, ObjectRef completed$1, ObjectRef failed$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = (JobExecutionStatus)tuple2._2();
            if (JobExecutionStatus.RUNNING.equals(jobExecutionStatus)) {
                running$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)running$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)id));
                return;
            }
        }
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = (JobExecutionStatus)tuple2._2();
            if (JobExecutionStatus.SUCCEEDED.equals(jobExecutionStatus)) {
                completed$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)completed$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)id));
                return;
            }
        }
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            JobExecutionStatus jobExecutionStatus = (JobExecutionStatus)tuple2._2();
            if (JobExecutionStatus.FAILED.equals(jobExecutionStatus)) {
                failed$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)failed$1.elem).$colon$plus((Object)BoxesRunTime.boxToInteger((int)id));
                return;
            }
        }
    }

    private static final Option getMetric$1(Map metricValues, long accumulatorId, String metricName) {
        return metricValues.get((Object)BoxesRunTime.boxToLong((long)accumulatorId)).map((Function1 & Serializable)mv -> {
            String metricValue = mv.startsWith("\n") ? mv.substring(1, mv.length()) : mv;
            return Metric$.MODULE$.apply(metricName, metricValue);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getNodeIdAndWSCGIdMap$1(SqlResource $this, SparkPlanGraphNode x$3) {
        return x$3.name().trim().startsWith($this.WHOLE_STAGE_CODEGEN());
    }

    public SqlResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
        BaseAppResource.$init$((BaseAppResource)this);
        this.WHOLE_STAGE_CODEGEN = "WholeStageCodegen";
    }
}

