/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client.transport.internal;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.client.Connection;
import org.sparkproject.jetty.client.Destination;
import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.client.HttpClientTransport;
import org.sparkproject.jetty.client.HttpResponseException;
import org.sparkproject.jetty.client.HttpUpgrader;
import org.sparkproject.jetty.client.Origin;
import org.sparkproject.jetty.client.Request;
import org.sparkproject.jetty.client.Response;
import org.sparkproject.jetty.client.transport.HttpClientTransportDynamic;
import org.sparkproject.jetty.client.transport.HttpDestination;
import org.sparkproject.jetty.client.transport.HttpResponse;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.io.EndPoint;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.Promise;

public class ProtocolHttpUpgrader
implements HttpUpgrader {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolHttpUpgrader.class);
    private final HttpDestination destination;
    private final String protocol;

    public ProtocolHttpUpgrader(HttpDestination destination, String protocol) {
        this.destination = destination;
        this.protocol = protocol;
    }

    @Override
    public void prepare(Request request) {
    }

    @Override
    public void upgrade(Response response, EndPoint endPoint, Callback callback) {
        if (response.getHeaders().contains(HttpHeader.UPGRADE, this.protocol)) {
            HttpClient httpClient = this.destination.getHttpClient();
            HttpClientTransport transport = httpClient.getHttpClientTransport();
            if (transport instanceof HttpClientTransportDynamic) {
                HttpClientTransportDynamic dynamicTransport = (HttpClientTransportDynamic)transport;
                Origin origin = this.destination.getOrigin();
                Origin newOrigin = new Origin(origin.getScheme(), origin.getAddress(), origin.getTag(), new Origin.Protocol(List.of(this.protocol), false), origin.getTransport());
                Destination newDestination = httpClient.resolveDestination(newOrigin);
                ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
                context.put(Destination.CONTEXT_KEY, newDestination);
                context.put(HttpResponse.class.getName(), response);
                context.put(Connection.PROMISE_CONTEXT_KEY, Promise.from(y -> callback.succeeded(), callback::failed));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Upgrading {} on {}", (Object)response.getRequest(), (Object)endPoint);
                }
                dynamicTransport.upgrade(endPoint, context);
            } else {
                callback.failed(new HttpResponseException(HttpClientTransportDynamic.class.getName() + " required to upgrade to: " + this.protocol, response));
            }
        } else {
            callback.failed(new HttpResponseException("Not an upgrade to: " + this.protocol, response));
        }
    }
}

