/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.handler;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.util.BufferUtil;
import org.sparkproject.jetty.util.Callback;

public abstract class EventsHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(EventsHandler.class);

    public EventsHandler() {
        this((Handler)null);
    }

    public EventsHandler(Handler handler) {
        super(handler);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Request roRequest = Request.asReadOnly(request);
        this.notifyOnBeforeHandling(roRequest);
        try {
            EventsRequest wrappedRequest = new EventsRequest(request, roRequest);
            EventsResponse wrappedResponse = new EventsResponse(roRequest, response);
            Request.addCompletionListener(request, x -> {
                this.notifyOnResponseBegin(roRequest, wrappedResponse);
                this.notifyOnResponseTrailersComplete(roRequest, wrappedResponse);
                this.notifyOnComplete(roRequest, wrappedResponse, (Throwable)x);
            });
            boolean handled = super.handle(wrappedRequest, wrappedResponse, callback);
            this.notifyOnAfterHandling(roRequest, handled, null);
            return handled;
        }
        catch (Throwable x2) {
            this.notifyOnAfterHandling(roRequest, false, x2);
            throw x2;
        }
    }

    private void notifyOnBeforeHandling(Request request) {
        try {
            this.onBeforeHandling(request);
        }
        catch (Throwable x) {
            LOG.info("Error firing onBeforeHandling", x);
        }
    }

    private void notifyOnRequestRead(Request wrapped, Content.Chunk chunk) {
        try {
            if (chunk == null) {
                this.onRequestRead(wrapped, null);
                return;
            }
            Content.Chunk readOnlyChunk = chunk.canRetain() ? Content.Chunk.asChunk(chunk.getByteBuffer().asReadOnlyBuffer(), chunk.isLast(), chunk) : Content.Chunk.from(chunk.getByteBuffer().asReadOnlyBuffer(), chunk.isLast());
            this.onRequestRead(wrapped, readOnlyChunk);
        }
        catch (Throwable x) {
            LOG.info("Error firing onRequestRead", x);
        }
    }

    private void notifyOnAfterHandling(Request request, boolean handled, Throwable failure) {
        try {
            this.onAfterHandling(request, handled, failure);
        }
        catch (Throwable x) {
            LOG.info("Error firing onAfterHandling", x);
        }
    }

    private void notifyOnResponseBegin(Request request, EventsResponse response) {
        try {
            if (!response.notifiedOnResponseBegin) {
                this.onResponseBegin(request, response.getStatus(), response.getHeaders().asImmutable());
                response.notifiedOnResponseBegin = true;
            }
        }
        catch (Throwable x) {
            LOG.info("Error firing onResponseBegin", x);
        }
    }

    private void notifyOnResponseWrite(Request request, boolean last, ByteBuffer content) {
        try {
            this.onResponseWrite(request, last, content == null ? null : content.asReadOnlyBuffer());
        }
        catch (Throwable x) {
            LOG.info("Error firing onResponseWrite", x);
        }
    }

    private void notifyOnResponseWriteComplete(Request request, Throwable failure) {
        try {
            this.onResponseWriteComplete(request, failure);
        }
        catch (Throwable x) {
            LOG.info("Error firing onResponseWriteComplete", x);
        }
    }

    private void notifyOnResponseTrailersComplete(Request request, EventsResponse response) {
        try {
            if (response.suppliedTrailers != null) {
                this.onResponseTrailersComplete(request, response.suppliedTrailers);
            }
        }
        catch (Throwable x) {
            LOG.info("Error firing onResponseTrailersComplete", x);
        }
    }

    private void notifyOnComplete(Request request, Response response, Throwable failure) {
        try {
            this.onComplete(request, response.getStatus(), response.getHeaders().asImmutable(), failure);
        }
        catch (Throwable x) {
            LOG.info("Error firing onComplete", x);
        }
    }

    protected void onBeforeHandling(Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeHandling of {}", (Object)request);
        }
    }

    protected void onRequestRead(Request request, Content.Chunk chunk) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequestRead of {} and {}", (Object)request, (Object)chunk);
        }
    }

    protected void onAfterHandling(Request request, boolean handled, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("onAfterHandling of {} handled={}", (Object)request, (Object)handled);
        }
    }

    protected void onResponseBegin(Request request, int status, HttpFields headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onResponseBegin of {} status={} headers={}", new Object[]{request, status, headers});
        }
    }

    protected void onResponseWrite(Request request, boolean last, ByteBuffer content) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onResponseWrite of {} last={} content={}", new Object[]{request, last, BufferUtil.toDetailString(content)});
        }
    }

    protected void onResponseWriteComplete(Request request, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("onResponseWriteComplete of {}", (Object)request);
        }
    }

    protected void onResponseTrailersComplete(Request request, HttpFields trailers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onResponseTrailersComplete of {}, trailers={}", (Object)request, (Object)trailers);
        }
    }

    @Deprecated
    protected void onComplete(Request request, Throwable failure) {
    }

    protected void onComplete(Request request, int status, HttpFields headers, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete of {} status={} headers={}", new Object[]{request, status, headers});
        }
        this.onComplete(request, failure);
    }

    private class EventsRequest
    extends Request.Wrapper {
        private final Request roRequest;

        public EventsRequest(Request request, Request roRequest) {
            super(request);
            this.roRequest = roRequest;
        }

        @Override
        public Content.Chunk read() {
            Content.Chunk chunk = super.read();
            EventsHandler.this.notifyOnRequestRead(this.roRequest, chunk);
            return chunk;
        }
    }

    private class EventsResponse
    extends Response.Wrapper {
        private boolean notifiedOnResponseBegin;
        private HttpFields suppliedTrailers;

        public EventsResponse(Request roRequest, Response response) {
            super(roRequest, response);
        }

        @Override
        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            EventsHandler.this.notifyOnResponseBegin(this.getRequest(), this);
            EventsHandler.this.notifyOnResponseWrite(this.getRequest(), last, byteBuffer);
            super.write(last, byteBuffer, Callback.from(callback.getInvocationType(), () -> {
                EventsHandler.this.notifyOnResponseWriteComplete(this.getRequest(), null);
                callback.succeeded();
            }, x -> {
                EventsHandler.this.notifyOnResponseWriteComplete(this.getRequest(), (Throwable)x);
                callback.failed((Throwable)x);
            }));
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
            super.setTrailersSupplier(trailers == null ? null : () -> {
                this.suppliedTrailers = (HttpFields)trailers.get();
                return this.suppliedTrailers;
            });
        }
    }
}

