/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util.thread;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.component.Dumpable;

@ManagedObject(value="Tracking Executor wrapper")
public class TrackingExecutor
implements Executor,
Dumpable {
    private final Executor _threadFactoryExecutor;
    private final Set<Thread> _threads = ConcurrentHashMap.newKeySet();
    private boolean _detailed;

    public TrackingExecutor(Executor executor, boolean detailed) {
        this._threadFactoryExecutor = executor;
        this._detailed = detailed;
    }

    @Override
    public void execute(Runnable task) {
        this._threadFactoryExecutor.execute(() -> {
            Thread thread = Thread.currentThread();
            try {
                this._threads.add(thread);
                task.run();
            }
            finally {
                this._threads.remove(thread);
            }
        });
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Object[] threads = this._threads.stream().map(x$0 -> new DumpableThread((Thread)x$0)).toArray();
        Dumpable.dumpObjects(out, indent, this._threadFactoryExecutor.toString() + " size=" + threads.length, threads);
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailed = detailedDump;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailed;
    }

    public int size() {
        return this._threads.size();
    }

    private class DumpableThread
    implements Dumpable {
        private final Thread _thread;

        private DumpableThread(Thread thread) {
            this._thread = thread;
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            if (TrackingExecutor.this._detailed) {
                Object[] stack = this._thread.getStackTrace();
                Dumpable.dumpObjects(out, indent, this._thread.toString(), stack);
            } else {
                Dumpable.dumpObject(out, this._thread);
            }
        }
    }
}

