/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversionFluentImpl;
import java.util.Objects;

public class CustomResourceConversionFluentImpl<A extends CustomResourceConversionFluent<A>>
extends BaseFluent<A>
implements CustomResourceConversionFluent<A> {
    private String strategy;
    private WebhookConversionBuilder webhook;

    public CustomResourceConversionFluentImpl() {
    }

    public CustomResourceConversionFluentImpl(CustomResourceConversion instance) {
        this.withStrategy(instance.getStrategy());
        this.withWebhook(instance.getWebhook());
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    @Deprecated
    public A withNewStrategy(String arg0) {
        return this.withStrategy(new String(arg0));
    }

    @Override
    @Deprecated
    public WebhookConversion getWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    @Override
    public WebhookConversion buildWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    @Override
    public A withWebhook(WebhookConversion webhook) {
        this._visitables.get("webhook").remove(this.webhook);
        if (webhook != null) {
            this.webhook = new WebhookConversionBuilder(webhook);
            this._visitables.get("webhook").add(this.webhook);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhook() {
        return this.webhook != null;
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhook() {
        return new WebhookNestedImpl();
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhookLike(WebhookConversion item) {
        return new WebhookNestedImpl(item);
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> editWebhook() {
        return this.withNewWebhookLike(this.getWebhook());
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhook() {
        return this.withNewWebhookLike(this.getWebhook() != null ? this.getWebhook() : new WebhookConversionBuilder().build());
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhookLike(WebhookConversion item) {
        return this.withNewWebhookLike(this.getWebhook() != null ? this.getWebhook() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl)o;
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.webhook != null ? !this.webhook.equals(that.webhook) : that.webhook != null);
    }

    public int hashCode() {
        return Objects.hash(this.strategy, this.webhook, super.hashCode());
    }

    public class WebhookNestedImpl<N>
    extends WebhookConversionFluentImpl<CustomResourceConversionFluent.WebhookNested<N>>
    implements CustomResourceConversionFluent.WebhookNested<N>,
    Nested<N> {
        private final WebhookConversionBuilder builder;

        WebhookNestedImpl(WebhookConversion item) {
            this.builder = new WebhookConversionBuilder(this, item);
        }

        WebhookNestedImpl() {
            this.builder = new WebhookConversionBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomResourceConversionFluentImpl.this.withWebhook(this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }
}

