/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import com.yubico.internal.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class BinaryUtil {
    public static byte[] copy(byte[] bytes) {
        return Arrays.copyOf(bytes, bytes.length);
    }

    public static byte[] copyInto(byte[] src, byte[] dest, int destFrom) {
        if (dest.length - destFrom < src.length) {
            throw new IllegalArgumentException("Source array will not fit in destination array");
        }
        if (destFrom < 0) {
            throw new IllegalArgumentException("Invalid destination range");
        }
        for (int i = 0; i < src.length; ++i) {
            dest[destFrom + i] = src[i];
        }
        return dest;
    }

    public static byte[] concat(byte[] ... arrays) {
        int len = Arrays.stream(arrays).map(a -> ((byte[])a).length).reduce(0, Integer::sum);
        byte[] result = new byte[len];
        int i = 0;
        for (byte[] src : arrays) {
            BinaryUtil.copyInto(src, result, i);
            i += src.length;
        }
        return result;
    }

    public static String toHex(byte[] bytes) {
        char[] digits = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int i2 = i * 2;
            digits[i2] = Character.forDigit(bytes[i] >> 4 & 0xF, 16);
            digits[i2 + 1] = Character.forDigit(bytes[i] & 0xF, 16);
        }
        return new String(digits);
    }

    public static byte[] fromHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Length of hex string is not even: " + hex);
        }
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); ++i) {
            int d = Character.digit(hex.charAt(i), 16);
            if (d < 0) {
                throw new IllegalArgumentException("Invalid hex digit at index " + i + " in: " + hex);
            }
            int n = i / 2;
            result[n] = (byte)(result[n] | d << (i + 1) % 2 * 4);
        }
        return result;
    }

    public static byte singleFromHex(String hex) {
        ExceptionUtil.assertTrue(hex.length() == 2, "Argument must be exactly 2 hexadecimal characters, was: %s", hex);
        return BinaryUtil.fromHex(hex)[0];
    }

    public static short getUint8(byte b) {
        return ByteBuffer.wrap(new byte[]{0, b}).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public static int getUint16(byte[] bytes) {
        if (bytes.length == 2) {
            return ByteBuffer.wrap(new byte[]{0, 0, bytes[0], bytes[1]}).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        throw new IllegalArgumentException("Argument must be 2 bytes, was: " + bytes.length);
    }

    public static long getUint32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(new byte[]{0, 0, 0, 0, bytes[0], bytes[1], bytes[2], bytes[3]}).order(ByteOrder.BIG_ENDIAN).getLong();
        }
        throw new IllegalArgumentException("Argument must be 4 bytes, was: " + bytes.length);
    }

    public static byte[] encodeUint16(int value) {
        ExceptionUtil.assertTrue(value >= 0, "Argument must be non-negative, was: %d", value);
        ExceptionUtil.assertTrue(value < 65536, "Argument must be smaller than 2^16=65536, was: %d", value);
        ByteBuffer b = ByteBuffer.allocate(4);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putInt(value);
        b.rewind();
        return Arrays.copyOfRange(b.array(), 2, 4);
    }

    public static byte[] encodeUint32(long value) {
        ExceptionUtil.assertTrue(value >= 0L, "Argument must be non-negative, was: %d", value);
        ExceptionUtil.assertTrue(value < 0x100000000L, "Argument must be smaller than 2^32=4294967296, was: %d", value);
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putLong(value);
        b.rewind();
        return Arrays.copyOfRange(b.array(), 4, 8);
    }

    public static byte[] readAll(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int bufferLen = 0;
        int moreLen;
        while ((moreLen = is.read(buffer, bufferLen, buffer.length - bufferLen)) > 0) {
            if ((bufferLen += moreLen) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        return Arrays.copyOf(buffer, bufferLen);
    }

    public static byte[] encodeDerLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length is negative: " + length);
        }
        if (length <= 127) {
            return new byte[]{(byte)(length & 0xFF)};
        }
        if (length <= 255) {
            return new byte[]{-127, (byte)(length & 0xFF)};
        }
        if (length <= 65535) {
            return new byte[]{-126, (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        }
        if (length <= 0xFFFFFF) {
            return new byte[]{-125, (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        }
        return new byte[]{-124, (byte)(length >> 24 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
    }

    public static ParseDerResult<Integer> parseDerLength(@NonNull byte[] der, int offset) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        int len = der.length - offset;
        if (len == 0) {
            throw new IllegalArgumentException("Empty input");
        }
        if ((der[offset] & 0x80) == 0) {
            return new ParseDerResult<Integer>(der[offset] & 0xFF, offset + 1);
        }
        int longLen = der[offset] & 0x7F;
        if (len >= longLen) {
            switch (longLen) {
                case 0: {
                    throw new IllegalArgumentException(String.format("Empty length encoding at offset %d: 0x%s", offset, BinaryUtil.toHex(der)));
                }
                case 1: {
                    return new ParseDerResult<Integer>(der[offset + 1] & 0xFF, offset + 2);
                }
                case 2: {
                    return new ParseDerResult<Integer>((der[offset + 1] & 0xFF) << 8 | der[offset + 2] & 0xFF, offset + 3);
                }
                case 3: {
                    return new ParseDerResult<Integer>((der[offset + 1] & 0xFF) << 16 | (der[offset + 2] & 0xFF) << 8 | der[offset + 3] & 0xFF, offset + 4);
                }
                case 4: {
                    if ((der[offset + 1] & 0x80) == 0) {
                        return new ParseDerResult<Integer>((der[offset + 1] & 0xFF) << 24 | (der[offset + 2] & 0xFF) << 16 | (der[offset + 3] & 0xFF) << 8 | der[offset + 4] & 0xFF, offset + 5);
                    }
                    throw new UnsupportedOperationException(String.format("Length out of range of int: 0x%02x%02x%02x%02x", der[offset + 1], der[offset + 2], der[offset + 3], der[offset + 4]));
                }
            }
            throw new UnsupportedOperationException(String.format("Length is too long for int: %d octets", longLen));
        }
        throw new IllegalArgumentException(String.format("Length encoding needs %d octets but only %s remain at index %d: 0x%s", longLen, len - (offset + 1), offset + 1, BinaryUtil.toHex(der)));
    }

    private static ParseDerAnyResult parseDerAny(@NonNull byte[] der, int offset) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        int len = der.length - offset;
        if (len == 0) {
            throw new IllegalArgumentException(String.format("Empty input at offset %d: 0x%s", offset, BinaryUtil.toHex(der)));
        }
        byte tag = der[offset];
        ParseDerResult<Integer> contentLen = BinaryUtil.parseDerLength(der, offset + 1);
        int contentEnd = contentLen.nextOffset + (Integer)contentLen.result;
        return new ParseDerAnyResult(DerTagClass.parse(tag), (tag & 0x20) != 0, (byte)(tag & 0x1F), contentLen.nextOffset, contentEnd);
    }

    public static ParseDerResult<Optional<Integer>> parseDerTaggedOrSkip(@NonNull byte[] der, int offset, byte expectTag, boolean constructed, DerTagClass expectTagClass) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        ParseDerAnyResult result = BinaryUtil.parseDerAny(der, offset);
        if (result.tagValue == expectTag && result.constructed == constructed && result.tagClass == expectTagClass) {
            return new ParseDerResult<Optional<Integer>>(Optional.of(result.valueStart), result.valueEnd);
        }
        return new ParseDerResult<Optional<Integer>>(Optional.empty(), result.valueEnd);
    }

    private static ParseDerResult<Integer> parseDerTagged(@NonNull byte[] der, int offset, byte expectTag, boolean constructed, DerTagClass expectTagClass) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        ParseDerAnyResult result = BinaryUtil.parseDerAny(der, offset);
        if (result.tagValue == expectTag) {
            if (result.constructed == constructed) {
                if (result.tagClass == expectTagClass) {
                    return new ParseDerResult<Integer>(result.valueStart, result.valueEnd);
                }
                throw new IllegalArgumentException(String.format("Incorrect tag class: expected %s, found %s at offset %d: 0x%s", new Object[]{expectTagClass, result.tagClass, offset, BinaryUtil.toHex(der)}));
            }
            throw new IllegalArgumentException(String.format("Incorrect constructed bit: expected %s, found %s at offset %d: 0x%s", constructed, result.constructed, offset, BinaryUtil.toHex(der)));
        }
        throw new IllegalArgumentException(String.format("Incorrect tag: expected 0x%02x, found 0x%02x at offset %d: 0x%s", expectTag, result.tagValue, offset, BinaryUtil.toHex(der)));
    }

    public static <T> ParseDerResult<List<T>> parseDerSequenceContents(@NonNull byte[] der, int offset, int endOffset, @NonNull ParseDerSequenceElementFunction<T> parseElement) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        if (parseElement == null) {
            throw new NullPointerException("parseElement is marked non-null but is null");
        }
        ArrayList result = new ArrayList();
        int seqOffset = offset;
        while (seqOffset < endOffset) {
            ParseDerResult<T> elementResult = parseElement.parse(der, seqOffset);
            result.add(elementResult.result);
            seqOffset = elementResult.nextOffset;
        }
        return new ParseDerResult<List<T>>(result, endOffset);
    }

    public static <T> ParseDerResult<List<T>> parseDerSequence(@NonNull byte[] der, int offset, @NonNull ParseDerSequenceElementFunction<T> parseElement) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        if (parseElement == null) {
            throw new NullPointerException("parseElement is marked non-null but is null");
        }
        ParseDerResult<Integer> seq = BinaryUtil.parseDerTagged(der, offset, (byte)16, true, DerTagClass.UNIVERSAL);
        ParseDerResult<List<T>> res = BinaryUtil.parseDerSequenceContents(der, (Integer)seq.result, seq.nextOffset, parseElement);
        return new ParseDerResult<List<T>>((List)res.result, seq.nextOffset);
    }

    public static ParseDerResult<byte[]> parseDerOctetString(@NonNull byte[] der, int offset) {
        if (der == null) {
            throw new NullPointerException("der is marked non-null but is null");
        }
        ParseDerResult<Integer> res = BinaryUtil.parseDerTagged(der, offset, (byte)4, false, DerTagClass.UNIVERSAL);
        return new ParseDerResult<byte[]>(Arrays.copyOfRange(der, (int)((Integer)res.result), res.nextOffset), res.nextOffset);
    }

    public static byte[] encodeDerObjectId(@NonNull byte[] oid) {
        if (oid == null) {
            throw new NullPointerException("oid is marked non-null but is null");
        }
        byte[] result = new byte[2 + oid.length];
        result[0] = 6;
        result[1] = (byte)oid.length;
        return BinaryUtil.copyInto(oid, result, 2);
    }

    public static byte[] encodeDerBitStringWithZeroUnused(@NonNull byte[] content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return BinaryUtil.concat({3}, BinaryUtil.encodeDerLength(1 + content.length), {0}, content);
    }

    public static byte[] encodeDerSequence(byte[] ... items) {
        byte[] content = BinaryUtil.concat(items);
        return BinaryUtil.concat({48}, BinaryUtil.encodeDerLength(content.length), content);
    }

    public static final class ParseDerResult<T> {
        public final T result;
        public final int nextOffset;

        @Generated
        public ParseDerResult(T result, int nextOffset) {
            this.result = result;
            this.nextOffset = nextOffset;
        }

        @Generated
        public T getResult() {
            return this.result;
        }

        @Generated
        public int getNextOffset() {
            return this.nextOffset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseDerResult)) {
                return false;
            }
            ParseDerResult other = (ParseDerResult)o;
            if (this.getNextOffset() != other.getNextOffset()) {
                return false;
            }
            T this$result = this.getResult();
            T other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNextOffset();
            T $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BinaryUtil.ParseDerResult(result=" + this.getResult() + ", nextOffset=" + this.getNextOffset() + ")";
        }
    }

    private static final class ParseDerAnyResult {
        private final DerTagClass tagClass;
        private final boolean constructed;
        private final byte tagValue;
        private final int valueStart;
        private final int valueEnd;

        @Generated
        public ParseDerAnyResult(DerTagClass tagClass, boolean constructed, byte tagValue, int valueStart, int valueEnd) {
            this.tagClass = tagClass;
            this.constructed = constructed;
            this.tagValue = tagValue;
            this.valueStart = valueStart;
            this.valueEnd = valueEnd;
        }

        @Generated
        public DerTagClass getTagClass() {
            return this.tagClass;
        }

        @Generated
        public boolean isConstructed() {
            return this.constructed;
        }

        @Generated
        public byte getTagValue() {
            return this.tagValue;
        }

        @Generated
        public int getValueStart() {
            return this.valueStart;
        }

        @Generated
        public int getValueEnd() {
            return this.valueEnd;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseDerAnyResult)) {
                return false;
            }
            ParseDerAnyResult other = (ParseDerAnyResult)o;
            if (this.isConstructed() != other.isConstructed()) {
                return false;
            }
            if (this.getTagValue() != other.getTagValue()) {
                return false;
            }
            if (this.getValueStart() != other.getValueStart()) {
                return false;
            }
            if (this.getValueEnd() != other.getValueEnd()) {
                return false;
            }
            DerTagClass this$tagClass = this.getTagClass();
            DerTagClass other$tagClass = other.getTagClass();
            return !(this$tagClass == null ? other$tagClass != null : !((Object)((Object)this$tagClass)).equals((Object)other$tagClass));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isConstructed() ? 79 : 97);
            result = result * 59 + this.getTagValue();
            result = result * 59 + this.getValueStart();
            result = result * 59 + this.getValueEnd();
            DerTagClass $tagClass = this.getTagClass();
            result = result * 59 + ($tagClass == null ? 43 : ((Object)((Object)$tagClass)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BinaryUtil.ParseDerAnyResult(tagClass=" + (Object)((Object)this.getTagClass()) + ", constructed=" + this.isConstructed() + ", tagValue=" + this.getTagValue() + ", valueStart=" + this.getValueStart() + ", valueEnd=" + this.getValueEnd() + ")";
        }
    }

    public static enum DerTagClass {
        UNIVERSAL,
        APPLICATION,
        CONTEXT_SPECIFIC,
        PRIVATE;


        public static DerTagClass parse(byte tag) {
            switch (tag >> 6 & 3) {
                case 0: {
                    return UNIVERSAL;
                }
                case 1: {
                    return APPLICATION;
                }
                case 2: {
                    return CONTEXT_SPECIFIC;
                }
                case 3: {
                    return PRIVATE;
                }
            }
            throw new RuntimeException("This should be impossible");
        }

        @Generated
        public String toString() {
            return "BinaryUtil.DerTagClass." + this.name();
        }
    }

    @FunctionalInterface
    public static interface ParseDerSequenceElementFunction<T> {
        public ParseDerResult<T> parse(@NonNull byte[] var1, int var2);
    }
}

