/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.dao;

import jakarta.validation.ValidationException;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public abstract class AbstractAnySearchDAO
implements AnySearchDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(AnySearchDAO.class);
    protected static final String ALWAYS_FALSE_CLAUSE = "1=2";
    private static final String[] ORDER_BY_NOT_ALLOWED = new String[]{"serialVersionUID", "password", "securityQuestion", "securityAnswer", "token", "tokenExpireTime"};
    protected static final String[] RELATIONSHIP_FIELDS = new String[]{"realm", "userOwner", "groupOwner"};
    protected final RealmSearchDAO realmSearchDAO;
    protected final DynRealmDAO dynRealmDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final PlainAttrValidationManager validator;

    protected static SearchCond buildEffectiveCond(SearchCond cond, Set<String> dynRealmKeys, Set<String> groupOwners, AnyTypeKind kind) {
        List<SearchCond> groupOwnerConds;
        ArrayList<SearchCond> result = new ArrayList<SearchCond>();
        result.add(cond);
        List<SearchCond> dynRealmConds = dynRealmKeys.stream().map(key -> {
            DynRealmCond dynRealmCond = new DynRealmCond();
            dynRealmCond.setDynRealm(key);
            return SearchCond.of((AbstractSearchCond)dynRealmCond);
        }).toList();
        if (!dynRealmConds.isEmpty()) {
            result.add(SearchCond.or(dynRealmConds));
        }
        if (!(groupOwnerConds = groupOwners.stream().map(key -> {
            MembershipCond asc;
            if (kind == AnyTypeKind.GROUP) {
                AnyCond anyCond = new AnyCond(AttrCond.Type.EQ);
                anyCond.setSchema("id");
                anyCond.setExpression(key);
                asc = anyCond;
            } else {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setGroup(key);
                asc = membershipCond;
            }
            return SearchCond.of((AbstractSearchCond)asc);
        }).toList()).isEmpty()) {
            result.add(SearchCond.or(groupOwnerConds));
        }
        return SearchCond.and(result);
    }

    public static String key(AttrSchemaType schemaType) {
        return switch (schemaType) {
            case AttrSchemaType.Boolean -> "booleanValue";
            case AttrSchemaType.Date -> "dateValue";
            case AttrSchemaType.Double -> "doubleValue";
            case AttrSchemaType.Long -> "longValue";
            case AttrSchemaType.Binary -> "binaryValue";
            default -> "stringValue";
        };
    }

    public AbstractAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator) {
        this.realmSearchDAO = realmSearchDAO;
        this.dynRealmDAO = dynRealmDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
        this.validator = validator;
    }

    protected abstract long doCount(Realm var1, boolean var2, Set<String> var3, SearchCond var4, AnyTypeKind var5);

    public long count(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        if (CollectionUtils.isEmpty(adminRealms)) {
            LOG.error("No realms provided");
            return 0L;
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return 0L;
        }
        return this.doCount(base, recursive, adminRealms, cond, kind);
    }

    public <T extends Any> List<T> search(SearchCond cond, AnyTypeKind kind) {
        return this.search(cond, List.of(), kind);
    }

    public <T extends Any> List<T> search(SearchCond cond, List<Sort.Order> orderBy, AnyTypeKind kind) {
        return this.search(this.realmSearchDAO.findByFullPath("/").orElse(null), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, Pageable.unpaged((Sort)Sort.by(orderBy)), kind);
    }

    protected abstract <T extends Any> List<T> doSearch(Realm var1, boolean var2, Set<String> var3, SearchCond var4, Pageable var5, AnyTypeKind var6);

    protected CheckResult<AttrCond> check(AttrCond cond) {
        PlainSchema schema = (PlainSchema)this.plainSchemaDAO.findById(cond.getSchema()).orElseThrow(() -> new IllegalArgumentException("Invalid schema " + cond.getSchema()));
        PlainAttrValue attrValue = new PlainAttrValue();
        if (AttrSchemaType.Encrypted == schema.getType()) {
            throw new IllegalArgumentException("Cannot search by encrypted schema " + cond.getSchema());
        }
        try {
            if (cond.getType() != AttrCond.Type.LIKE && cond.getType() != AttrCond.Type.ILIKE && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
                this.validator.validate(schema, cond.getExpression(), attrValue);
            }
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("Could not validate expression " + cond.getExpression());
        }
        return new CheckResult<AttrCond>(schema, attrValue, cond);
    }

    protected CheckResult<AnyCond> check(AnyCond cond, AnyTypeKind kind) {
        AnyCond computed = new AnyCond(cond.getType());
        computed.setSchema(cond.getSchema());
        computed.setExpression(cond.getExpression());
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        Field anyField = (Field)anyUtils.getField(computed.getSchema()).orElseThrow(() -> new IllegalArgumentException("Invalid schema " + computed.getSchema()));
        if ("key".equals(computed.getSchema())) {
            computed.setSchema("id");
        }
        PlainSchema schema = (PlainSchema)this.entityFactory.newEntity(PlainSchema.class);
        schema.setKey(anyField.getName());
        for (AttrSchemaType attrSchemaType : AttrSchemaType.values()) {
            if (!anyField.getType().isAssignableFrom(attrSchemaType.getType())) continue;
            schema.setType(attrSchemaType);
        }
        if (schema.getType() == null || schema.getType() == AttrSchemaType.Dropdown) {
            schema.setType(AttrSchemaType.String);
        }
        boolean foundBooleanMin = false;
        boolean foundBooleanMax = false;
        if (Integer.class.equals(anyField.getType())) {
            for (Annotation annotation : anyField.getAnnotations()) {
                if (Min.class.equals(annotation.annotationType())) {
                    foundBooleanMin = ((Min)annotation).value() == 0L;
                    continue;
                }
                if (!Max.class.equals(annotation.annotationType())) continue;
                foundBooleanMax = ((Max)annotation).value() == 1L;
            }
        }
        if (foundBooleanMin && foundBooleanMax) {
            schema.setType(AttrSchemaType.Boolean);
        }
        if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)computed.getSchema())) {
            computed.setSchema(computed.getSchema() + "_id");
            schema.setType(AttrSchemaType.String);
        }
        PlainAttrValue attrValue = new PlainAttrValue();
        if (computed.getType() != AttrCond.Type.LIKE && computed.getType() != AttrCond.Type.ILIKE && computed.getType() != AttrCond.Type.ISNULL && computed.getType() != AttrCond.Type.ISNOTNULL) {
            try {
                this.validator.validate(schema, computed.getExpression(), attrValue);
            }
            catch (ValidationException e) {
                LOG.error("Could not validate expression {}", (Object)computed.getExpression(), (Object)e);
                throw new IllegalArgumentException("Could not validate expression " + computed.getExpression());
            }
        }
        return new CheckResult<AnyCond>(schema, attrValue, computed);
    }

    protected boolean isPatternMatch(String clause) {
        return clause.indexOf(37) != -1;
    }

    protected List<String> check(MembershipCond cond) {
        List groups;
        List list = SyncopeConstants.UUID_PATTERN.matcher(cond.getGroup()).matches() ? List.of(cond.getGroup()) : (groups = this.isPatternMatch(cond.getGroup()) ? this.groupDAO.findKeysByNamePattern(cond.getGroup().toLowerCase()) : this.groupDAO.findKey(cond.getGroup()).map(List::of).orElseGet(List::of));
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("Could not find group(s) for " + cond.getGroup());
        }
        return groups;
    }

    protected Set<String> check(RelationshipCond cond) {
        Set<String> rightAnyObjects;
        Set<String> set = cond.getAnyObject() == null ? Set.of() : (rightAnyObjects = SyncopeConstants.UUID_PATTERN.matcher(cond.getAnyObject()).matches() ? Set.of(cond.getAnyObject()) : this.anyObjectDAO.findByName(cond.getAnyObject()).stream().map(Entity::getKey).collect(Collectors.toSet()));
        if (rightAnyObjects.isEmpty()) {
            throw new IllegalArgumentException("Could not find any object for " + cond.getAnyObject());
        }
        return rightAnyObjects;
    }

    protected Set<String> check(MemberCond cond) {
        Set<String> members;
        Set<String> set = cond.getMember() == null ? Set.of() : (members = SyncopeConstants.UUID_PATTERN.matcher(cond.getMember()).matches() ? Set.of(cond.getMember()) : this.userDAO.findKey(cond.getMember()).map(Set::of).orElseGet(() -> this.anyObjectDAO.findByName(cond.getMember()).stream().map(Entity::getKey).collect(Collectors.toSet())));
        if (members.isEmpty()) {
            throw new IllegalArgumentException("Could not find user or any object for " + cond.getMember());
        }
        return members;
    }

    protected <T extends Any> List<T> buildResult(List<Object> raw, AnyTypeKind kind) {
        List<String> keys = raw.stream().map(key -> {
            String string;
            if (key instanceof Object[]) {
                Object[] array = (Object[])key;
                string = (String)array[0];
            } else {
                string = (String)key;
            }
            return string;
        }).toList();
        List<Any> anys = this.anyUtilsFactory.getInstance(kind).dao().findByKeys(keys).stream().sorted(Comparator.comparing(any -> keys.indexOf(any.getKey()))).toList();
        keys.stream().filter(key -> anys.stream().noneMatch(any -> key.equals(any.getKey()))).forEach(key -> LOG.error("Could not find {} with id {}, even if returned by native query", (Object)kind, key));
        return anys;
    }

    public <T extends Any> List<T> search(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, Pageable pageable, AnyTypeKind kind) {
        if (CollectionUtils.isEmpty(adminRealms)) {
            LOG.error("No realms provided");
            return List.of();
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return List.of();
        }
        List<Sort.Order> effectiveOrderBy = pageable.getSort().isEmpty() ? List.of(new Sort.Order(Sort.Direction.ASC, kind == AnyTypeKind.USER ? "username" : "name")) : pageable.getSort().stream().filter(clause -> !ArrayUtils.contains((Object[])ORDER_BY_NOT_ALLOWED, (Object)clause.getProperty())).toList();
        return this.doSearch(base, recursive, adminRealms, cond, (Pageable)(pageable.isUnpaged() ? Pageable.unpaged((Sort)Sort.by(effectiveOrderBy)) : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(effectiveOrderBy))), kind);
    }

    protected record CheckResult<C extends AttrCond>(PlainSchema schema, PlainAttrValue value, C cond) {
    }
}

