/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.util.Set;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.RelationshipTypeCheck;

public class RelationshipTypeValidator
extends AbstractValidator<RelationshipTypeCheck, RelationshipType> {
    private static final Set<String> INVALID_KEYS = Set.of("UMembership", "AMembership", "membership");

    public boolean isValid(RelationshipType relationshipType, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (RelationshipTypeValidator.isHtml(relationshipType.getKey())) {
            context.buildConstraintViolationWithTemplate(RelationshipTypeValidator.getTemplate(EntityViolationType.InvalidKey, relationshipType.getKey())).addPropertyNode("key").addConstraintViolation();
            isValid = false;
        }
        if (INVALID_KEYS.stream().anyMatch(k -> k.equalsIgnoreCase(relationshipType.getKey()))) {
            context.buildConstraintViolationWithTemplate(RelationshipTypeValidator.getTemplate(EntityViolationType.InvalidKey, relationshipType.getKey())).addPropertyNode("key").addConstraintViolation();
            isValid = false;
        }
        if (relationshipType.getRightEndAnyType() != null && relationshipType.getRightEndAnyType().getKind() != AnyTypeKind.ANY_OBJECT) {
            context.buildConstraintViolationWithTemplate(RelationshipTypeValidator.getTemplate(EntityViolationType.InvalidAnyType, relationshipType.getRightEndAnyType().getKind().name())).addPropertyNode("rightEndAnyType").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

