/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.task;

import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.core.flowable.task.FlowableServiceTask;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.flowable.engine.delegate.DelegateExecution;

public class Update
extends FlowableServiceTask {
    protected final UserDataBinder dataBinder;
    protected final UserDAO userDAO;

    public Update(UserDataBinder dataBinder, UserDAO userDAO) {
        this.dataBinder = dataBinder;
        this.userDAO = userDAO;
    }

    @Override
    protected void doExecute(DelegateExecution execution) {
        UserUR req = (UserUR)execution.getVariable("userUR", UserUR.class);
        if (req == null || req.isEmpty()) {
            LOG.warn("No actual update is to be performed: empty or null request");
        } else {
            User user = (User)execution.getVariable("user", User.class);
            user = (User)this.userDAO.save((Entity)user);
            UserWorkflowResult.PropagationInfo propInfo = this.dataBinder.update(user, req);
            execution.setVariable("user", (Object)user);
            execution.setVariable("propByResource", (Object)propInfo.user());
            execution.setVariable("propByLinkedAccount", (Object)propInfo.linkedAccount());
        }
    }
}

