/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.okta.sdk.client.Client;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.okta.BaseOktaApiProperties;
import org.apereo.cas.configuration.model.support.okta.OktaPrincipalProvisioningProperties;
import org.apereo.cas.okta.OktaConfigurationFactory;
import org.apereo.cas.okta.OktaPrincipalProvisioner;
import org.apereo.cas.okta.web.flow.OktaWebflowConfigurer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.PrincipalProvisionerAction;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Provisioning}, module="okta")
@Configuration(value="OktaProvisioningConfiguration", proxyBeanMethods=false)
class OktaProvisioningConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.okta.provisioning.enabled").isTrue().and("cas.authn.okta.provisioning.organization-url");

    OktaProvisioningConfiguration() {
    }

    @ConditionalOnMissingBean(name={"oktaProvisioningClient"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Client oktaProvisioningClient(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (Client)BeanSupplier.of(Client.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            OktaPrincipalProvisioningProperties properties = casProperties.getAuthn().getOkta().getProvisioning();
            return OktaConfigurationFactory.buildClient((BaseOktaApiProperties)properties);
        }).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalProvisioner principalProvisioner(@Qualifier(value="oktaProvisioningClient") Client oktaProvisioningClient, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        return (PrincipalProvisioner)BeanSupplier.of(PrincipalProvisioner.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new OktaPrincipalProvisioner(oktaProvisioningClient, casProperties.getAuthn().getOkta().getProvisioning())).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"oktaPrincipalProvisionerAction"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action oktaPrincipalProvisionerAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="principalProvisioner") PrincipalProvisioner principalProvisioner) {
        return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new PrincipalProvisionerAction(principalProvisioner, casProperties.getScim())).otherwise(() -> ConsumerExecutionAction.NONE).get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"oktaCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer oktaCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="oktaWebflowConfigurer") CasWebflowConfigurer oktaWebflowConfigurer) {
        return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(oktaWebflowConfigurer)).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"oktaWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer oktaWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new OktaWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
    }
}

