/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.task;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;

public class VirtualThreadPoolTaskExecutor
extends ExecutorConfigurationSupport
implements AsyncTaskExecutor,
SchedulingTaskExecutor {
    private static final long serialVersionUID = 4747270938984213408L;
    private int poolSize = -1;
    private long taskTerminationTimeout;
    private TaskDecorator taskDecorator;
    private SimpleAsyncTaskExecutor executor;

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setTaskTerminationTimeout(long taskTerminationTimeout) {
        this.taskTerminationTimeout = taskTerminationTimeout;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.executor = new SimpleAsyncTaskExecutor(this.getThreadNamePrefix());
        this.executor.setVirtualThreads(true);
        this.executor.setDaemon(true);
        this.executor.setConcurrencyLimit(this.poolSize);
        if (this.taskTerminationTimeout >= 0L) {
            this.executor.setTaskTerminationTimeout(this.taskTerminationTimeout);
        }
        Optional.ofNullable(this.taskDecorator).ifPresent(arg_0 -> ((SimpleAsyncTaskExecutor)this.executor).setTaskDecorator(arg_0));
        return new AbstractExecutorService(){

            @Override
            public void execute(Runnable task) {
                VirtualThreadPoolTaskExecutor.this.executor.execute(task);
            }

            @Override
            public void shutdown() {
                VirtualThreadPoolTaskExecutor.this.executor.close();
            }

            @Override
            public List<Runnable> shutdownNow() {
                VirtualThreadPoolTaskExecutor.this.executor.close();
                return List.of();
            }

            @Override
            public boolean isShutdown() {
                return !VirtualThreadPoolTaskExecutor.this.executor.isActive();
            }

            @Override
            public boolean isTerminated() {
                return !VirtualThreadPoolTaskExecutor.this.executor.isActive();
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return !VirtualThreadPoolTaskExecutor.this.executor.isActive();
            }
        };
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public void shutdown() {
        this.executor.close();
    }
}

