/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.servicenow.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class SNUtils {
    private static final Log LOG = Log.getLog(SNUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static GuardedString createProtectedPassword(String password) {
        GuardedString guardedString = new GuardedString(password.toCharArray());
        return guardedString;
    }

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static boolean isEmptyObject(Object obj) {
        return obj == null || obj instanceof List && new ArrayList((List)obj).isEmpty() || obj instanceof String && StringUtil.isBlank((String)((String)String.class.cast(obj)));
    }

    public static String fromUnderscoredToCamelCase(String str) {
        if (!str.contains("_") || str.contains("__")) {
            return str;
        }
        String camelCaseString = "";
        for (String part : str.split("_")) {
            camelCaseString = camelCaseString + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
        }
        return camelCaseString.substring(0, 1).toLowerCase() + camelCaseString.substring(1);
    }

    public static String fromCamelCaseToUnderscored(String str) {
        return str.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }
}

