/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.http.client.ClientHttpRequestInterceptor;

public abstract class AbstractLoadBalancerBlockingBuilderBeanPostProcessor<T extends ClientHttpRequestInterceptor>
implements BeanPostProcessor {
    protected final ObjectProvider<T> loadBalancerInterceptorProvider;
    protected final ApplicationContext context;

    AbstractLoadBalancerBlockingBuilderBeanPostProcessor(ObjectProvider<T> loadBalancerInterceptorProvider, ApplicationContext context) {
        this.loadBalancerInterceptorProvider = loadBalancerInterceptorProvider;
        this.context = context;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.isSupported(bean)) {
            if (this.context.findAnnotationOnBean(beanName, LoadBalanced.class) == null) {
                return bean;
            }
            ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)this.loadBalancerInterceptorProvider.getIfAvailable();
            if (interceptor == null) {
                throw new IllegalStateException(ClientHttpRequestInterceptor.class.getSimpleName() + " not available.");
            }
            bean = this.apply(bean, interceptor);
        }
        return bean;
    }

    protected abstract Object apply(Object var1, ClientHttpRequestInterceptor var2);

    protected abstract boolean isSupported(Object var1);
}

