/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.de.odysseus.el.ExpressionFactoryImpl;
import org.flowable.common.engine.impl.de.odysseus.el.tree.TreeBuilder;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.Builder;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.Parser;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstFunction;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstIdentifier;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstParameters;
import org.flowable.common.engine.impl.el.FlowableAstFunctionCreator;
import org.flowable.common.engine.impl.el.FlowableExpressionParser;

public class FlowableExpressionFactory
extends ExpressionFactoryImpl {
    @Override
    protected TreeBuilder createDefaultTreeBuilder(Builder.Feature ... features) {
        return new FlowableExpressionBuilder(features);
    }

    public void setAstFunctionCreators(Collection<FlowableAstFunctionCreator> astFunctionCreators) {
        TreeBuilder storeBuilder = this.store.getBuilder();
        if (storeBuilder instanceof FlowableExpressionBuilder) {
            FlowableExpressionBuilder expressionBuilder = (FlowableExpressionBuilder)storeBuilder;
            expressionBuilder.getAstFunctionCreators().clear();
            for (FlowableAstFunctionCreator astFunctionCreator : astFunctionCreators) {
                expressionBuilder.addAstFunctionCreator(astFunctionCreator);
            }
        }
    }

    protected static class FlowableExpressionBuilder
    extends Builder {
        protected final Map<String, FlowableAstFunctionCreator> astFunctionCreators = new HashMap<String, FlowableAstFunctionCreator>();
        protected FlowableAstFunctionCreator defaultFunctionCreator = new FlowableAstFunctionCreator(){

            @Override
            public Collection<String> getFunctionNames() {
                return Collections.emptySet();
            }

            @Override
            public AstFunction createFunction(String name, int index, AstParameters parameters, boolean varargs, FlowableExpressionParser parser) {
                return new AstFunction(name, index, parameters, varargs);
            }
        };

        protected FlowableExpressionBuilder(Builder.Feature ... features) {
            super(features);
        }

        @Override
        protected Parser createParser(String expression) {
            return new FlowableExpressionParserImpl(this, expression);
        }

        public void addAstFunctionCreator(FlowableAstFunctionCreator astFunctionCreator) {
            for (String functionName : astFunctionCreator.getFunctionNames()) {
                this.astFunctionCreators.put(functionName, astFunctionCreator);
            }
        }

        public Map<String, FlowableAstFunctionCreator> getAstFunctionCreators() {
            return this.astFunctionCreators;
        }

        public FlowableAstFunctionCreator getAstFunctionCreator(String functionName) {
            return this.astFunctionCreators.getOrDefault(functionName, this.getDefaultFunctionCreator());
        }

        public FlowableAstFunctionCreator getDefaultFunctionCreator() {
            return this.defaultFunctionCreator;
        }

        public void setDefaultFunctionCreator(FlowableAstFunctionCreator defaultFunctionCreator) {
            this.defaultFunctionCreator = defaultFunctionCreator;
        }
    }

    protected static class FlowableExpressionParserImpl
    extends Parser
    implements FlowableExpressionParser {
        protected final FlowableExpressionBuilder flowableContext;

        public FlowableExpressionParserImpl(FlowableExpressionBuilder context, String input) {
            super(context, input);
            this.flowableContext = context;
        }

        @Override
        public AstIdentifier createIdentifier(String name) {
            return this.identifier(name);
        }

        @Override
        protected AstFunction createAstFunction(String name, int index, AstParameters params) {
            return this.flowableContext.getAstFunctionCreator(name).createFunction(name, index, params, this.context.isEnabled(Builder.Feature.VARARGS), this);
        }
    }
}

