/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.its.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Integers;

class ClassUtil {
    private static final Class gcmSpecClass = ClassUtil.loadClass(ClassUtil.class, "javax.crypto.spec.GCMParameterSpec");

    ClassUtil() {
    }

    public static AlgorithmParameterSpec getGCMSpec(final byte[] byArray, final int n) {
        if (gcmSpecClass != null) {
            try {
                return (AlgorithmParameterSpec)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                            return constructor.newInstance(Integers.valueOf((int)n), byArray);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new IllegalStateException("no matching constructor: " + noSuchMethodException.getMessage());
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("constructor failed" + exception.getMessage());
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return new AEADParameterSpec(byArray, n);
    }

    static Class loadClass(Class clazz, final String string) {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(string);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

