/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.InvalidViewIdException;
import org.apache.myfaces.application.TreeStructureManager;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.core.api.shared.lang.Assert;

public abstract class ViewDeclarationLanguageBase
extends ViewDeclarationLanguage {
    private static final Logger log = Logger.getLogger(ViewDeclarationLanguageBase.class.getName());
    private RenderKitFactory _renderKitFactory;

    public UIViewRoot createView(FacesContext context, String viewId) {
        Assert.notNull((Object)context, (String)"context");
        try {
            viewId = this.calculateViewId(context, viewId);
            Application application = context.getApplication();
            UIViewRoot newViewRoot = (UIViewRoot)application.createComponent(context, "jakarta.faces.ViewRoot", null);
            UIViewRoot oldViewRoot = context.getViewRoot();
            if (oldViewRoot == null) {
                ViewHandler handler = application.getViewHandler();
                newViewRoot.setLocale(handler.calculateLocale(context));
                newViewRoot.setRenderKitId(handler.calculateRenderKitId(context));
            } else {
                newViewRoot.setLocale(oldViewRoot.getLocale());
                newViewRoot.setRenderKitId(oldViewRoot.getRenderKitId());
            }
            newViewRoot.setViewId(viewId);
            return newViewRoot;
        }
        catch (InvalidViewIdException e) {
            this.sendSourceNotFound(context, e.getMessage());
            return null;
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Assert.notNull((Object)context, (String)"context");
        Application application = context.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(context);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering restoreView - viewId: " + viewId + " ; renderKitId: " + renderKitId);
        }
        UIViewRoot viewRoot = null;
        StateManagementStrategy sms = this.getStateManagementStrategy(context, viewId);
        if (sms != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Redirect to StateManagementStrategy: " + sms.getClass().getName());
            }
            viewRoot = sms.restoreView(context, viewId, renderKitId);
        } else {
            Object[] stateArray;
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(context, renderKitId);
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            Object state = responseStateManager.getState(context, viewId);
            if (state != null && (viewRoot = TreeStructureManager.restoreTreeStructure(((Object[])(stateArray = (Object[])state)[0])[0])) != null) {
                context.setViewRoot(viewRoot);
                viewRoot.processRestoreState(context, stateArray[1]);
                RequestViewContext.getCurrentInstance(context).refreshRequestViewContext(context, viewRoot);
                Object rlc = ((Object[])stateArray[0])[1];
                if (rlc != null) {
                    context.setResourceLibraryContracts((List)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)rlc));
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting restoreView - " + viewId);
        }
        return viewRoot;
    }

    protected abstract String calculateViewId(FacesContext var1, String var2);

    protected abstract void sendSourceNotFound(FacesContext var1, String var2);

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }
}

