/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import jakarta.json.JsonStructure;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.johnzon.jaxrs.IgnorableTypes;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;

@Produces(value={"application/json", "*/json", "*/*+json", "*/x-json", "*/javascript", "*/x-javascript"})
public class JohnzonMessageBodyWriter<T>
extends IgnorableTypes
implements MessageBodyWriter<T> {
    private final Mapper mapper;

    public JohnzonMessageBodyWriter() {
        this(new MapperBuilder().setDoCloseOnStreams(false).build(), null);
    }

    public JohnzonMessageBodyWriter(Mapper mapper, Collection<String> ignoredTypes) {
        super(ignoredTypes);
        this.mapper = mapper;
    }

    public long getSize(T t, Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isIgnored(rawType) && !InputStream.class.isAssignableFrom(rawType) && !OutputStream.class.isAssignableFrom(rawType) && !Writer.class.isAssignableFrom(rawType) && !StreamingOutput.class.isAssignableFrom(rawType) && !CharSequence.class.isAssignableFrom(rawType) && !Response.class.isAssignableFrom(rawType) && !JsonStructure.class.isAssignableFrom(rawType);
    }

    public void writeTo(T t, Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (rawType.isArray()) {
            this.mapper.writeArray(t, entityStream);
        } else if (Collection.class.isInstance(t)) {
            this.mapper.writeArray((Collection)Collection.class.cast(t), entityStream);
        } else {
            this.mapper.writeObject(t, entityStream);
        }
    }
}

