/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.Key;
import io.churchkey.asn1.Asn1Object;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.dsa.Dsa;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class BeginDsaPrivateKey {
    private BeginDsaPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            DerParser parser = new DerParser(bytes);
            Asn1Object sequence = parser.readObject();
            if (sequence.getType() != Asn1Type.SEQUENCE) {
                throw new IllegalArgumentException("Invalid DER: not a sequence");
            }
            DerParser parser1 = sequence.createParser();
            parser1.readObject();
            Dsa.Private build = Dsa.Private.builder().p(parser1.readObject().asInteger()).q(parser1.readObject().asInteger()).g(parser1.readObject().asInteger()).y(parser1.readObject().asInteger()).x(parser1.readObject().asInteger()).build();
            DSAPrivateKey privateKey = build.toKey();
            DSAPublicKey publicKey = build.toPublic().toKey();
            return new Key((java.security.Key)privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

