/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.servers;

import io.smallrye.openapi.api.models.servers.ServerVariableImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.jboss.jandex.AnnotationInstance;

public class ServerVariableIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<ServerVariable, V, A, O, AB, OB> {
    private static final String PROP_ENUM = "enum";
    private static final String PROP_DEFAULT_VALUE = "defaultValue";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_ENUMERATION = "enumeration";
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    protected ServerVariableIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.SERVER_VARIABLE, Names.create(ServerVariable.class));
        this.extensionIO = extensionIO;
    }

    @Override
    public ServerVariable read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@ServerVariable");
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        String[] enumeration = (String[])this.value(annotation, PROP_ENUMERATION);
        if (enumeration != null) {
            variable.setEnumeration(new ArrayList<String>(Arrays.asList(enumeration)));
        }
        variable.setDefaultValue((String)this.value(annotation, PROP_DEFAULT_VALUE));
        variable.setExtensions(this.extensionIO.readExtensible(annotation));
        return variable;
    }

    @Override
    public ServerVariable readObject(O node) {
        IoLogging.logger.singleJsonNode("ServerVariable");
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setEnumeration(this.jsonIO().getArray(node, PROP_ENUM, this.jsonIO()::asString).orElse(null));
        variable.setDefaultValue(this.jsonIO().getString(node, PROP_DEFAULT));
        variable.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        variable.setExtensions(this.extensionIO.readMap(node));
        return variable;
    }

    @Override
    public Optional<O> write(ServerVariable model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_DEFAULT, this.jsonIO().toJson(model.getDefaultValue()));
            this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            this.setIfPresent(node, PROP_ENUM, this.jsonIO().toJson(model.getEnumeration()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

