/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.health;

import io.smallrye.health.SmallRyeHealthReporter;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.microprofile.health.MicroProfileHealthReporter;
import org.apache.tomee.microprofile.health.MicroProfileHealthReporterProducer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

public class MPHealthCDIExtension
implements Extension {
    private static final String MP_HEALTH_DISABLE_DEFAULT_PROCEDURES = "mp.health.disable-default-procedures";
    private Instance<Object> instance;
    private final List<HealthCheck> livenessChecks = new ArrayList<HealthCheck>();
    private final List<HealthCheck> readinessChecks = new ArrayList<HealthCheck>();
    private final List<HealthCheck> startupChecks = new ArrayList<HealthCheck>();
    private HealthCheck defaultReadinessCheck;
    private HealthCheck defaultStartupCheck;
    private MicroProfileHealthReporter reporter;

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager beanManager) {
        if ("none".equals(SystemInstance.get().getOptions().get("tomee.mp.scan", "none"))) {
            return;
        }
        bbd.addAnnotatedType(beanManager.createAnnotatedType(MicroProfileHealthReporterProducer.class), "MicroProfileHealthReporterProducer");
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation avd, BeanManager bm) {
        Config config;
        boolean disableDefaultprocedure;
        if ("none".equals(SystemInstance.get().getOptions().get("tomee.mp.scan", "none"))) {
            return;
        }
        this.instance = bm.createInstance();
        Instance reporters = this.instance.select(MicroProfileHealthReporter.class, new Annotation[0]);
        Optional microProfileHealthReporter = reporters.stream().findFirst();
        if (microProfileHealthReporter.isEmpty()) {
            throw new IllegalStateException("Most likely a bug. No reporter found in the bean manager");
        }
        this.reporter = (MicroProfileHealthReporter)microProfileHealthReporter.get();
        this.addHealthChecks((AnnotationLiteral)Liveness.Literal.INSTANCE, this.reporter::addLivenessCheck, this.livenessChecks);
        this.addHealthChecks((AnnotationLiteral)Readiness.Literal.INSTANCE, this.reporter::addReadinessCheck, this.readinessChecks);
        this.addHealthChecks((AnnotationLiteral)Startup.Literal.INSTANCE, this.reporter::addStartupCheck, this.startupChecks);
        this.reporter.setUserChecksProcessed(true);
        if (this.readinessChecks.isEmpty() && !(disableDefaultprocedure = (config = ConfigProvider.getConfig((ClassLoader)MPHealthCDIExtension.class.getClassLoader())).getOptionalValue(MP_HEALTH_DISABLE_DEFAULT_PROCEDURES, Boolean.class).orElse(false).booleanValue())) {
            this.defaultReadinessCheck = new DefaultReadinessHealthCheck("Apache TomEE Server");
            this.reporter.addReadinessCheck(this.defaultReadinessCheck, MPHealthCDIExtension.class.getClassLoader());
        }
        if (this.startupChecks.isEmpty() && !(disableDefaultprocedure = (config = ConfigProvider.getConfig((ClassLoader)MPHealthCDIExtension.class.getClassLoader())).getOptionalValue(MP_HEALTH_DISABLE_DEFAULT_PROCEDURES, Boolean.class).orElse(false).booleanValue())) {
            this.defaultStartupCheck = new DefaultStartupHealthCheck("Apache TomEE Server");
            this.reporter.addStartupCheck(this.defaultStartupCheck, MPHealthCDIExtension.class.getClassLoader());
        }
    }

    private void addHealthChecks(AnnotationLiteral qualifier, BiConsumer<HealthCheck, ClassLoader> healthFunction, List<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : this.instance.select(HealthCheck.class, new Annotation[]{qualifier})) {
            healthFunction.accept(healthCheck, MPHealthCDIExtension.class.getClassLoader());
            healthChecks.add(healthCheck);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        if (this.reporter == null) {
            return;
        }
        this.removeHealthCheck(this.livenessChecks, this.reporter::removeLivenessCheck);
        this.removeHealthCheck(this.readinessChecks, this.reporter::removeReadinessCheck);
        this.removeHealthCheck(this.startupChecks, this.reporter::removeStartupCheck);
        if (this.defaultReadinessCheck != null) {
            this.reporter.removeReadinessCheck(this.defaultReadinessCheck);
            this.defaultReadinessCheck = null;
        }
        if (this.defaultStartupCheck != null) {
            this.reporter.removeStartupCheck(this.defaultStartupCheck);
            this.defaultStartupCheck = null;
        }
        this.instance = null;
    }

    private void removeHealthCheck(List<HealthCheck> healthChecks, Consumer<HealthCheck> healthFunction) {
        for (HealthCheck healthCheck : healthChecks) {
            healthFunction.accept(healthCheck);
            this.instance.destroy((Object)healthCheck);
        }
        healthChecks.clear();
    }

    public void vetoSmallryeHealthReporter(@Observes ProcessAnnotatedType<SmallRyeHealthReporter> pat) {
        pat.veto();
    }

    private static final class DefaultReadinessHealthCheck
    implements HealthCheck {
        private final String deploymentName;

        DefaultReadinessHealthCheck(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public HealthCheckResponse call() {
            return HealthCheckResponse.named((String)("ready-" + this.deploymentName)).up().build();
        }
    }

    private static final class DefaultStartupHealthCheck
    implements HealthCheck {
        private final String deploymentName;

        DefaultStartupHealthCheck(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public HealthCheckResponse call() {
            return HealthCheckResponse.named((String)("started-" + this.deploymentName)).up().build();
        }
    }
}

