/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import java.util.Formatter;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IInitializer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadStatusResource;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.lang.Args;

public class UploadProgressBar
extends Panel {
    public static final String RESOURCE_STARTING = "UploadProgressBar.starting";
    private static final ResourceReference JS = new JavaScriptResourceReference(UploadProgressBar.class, "progressbar.js");
    private static final ResourceReference CSS = new CssResourceReference(UploadProgressBar.class, "UploadProgressBar.css");
    private static final String RESOURCE_NAME = UploadProgressBar.class.getName();
    private static final long serialVersionUID = 1L;
    private Form<?> form;
    private MarkupContainer statusDiv;
    private MarkupContainer barDiv;
    private final FileUploadField uploadField;

    public UploadProgressBar(String id, FileUploadField uploadField) {
        super(id);
        this.uploadField = uploadField;
        if (uploadField != null) {
            uploadField.setOutputMarkupId(true);
        }
        this.setRenderBodyOnly(true);
    }

    public UploadProgressBar(String id, Form<?> form) {
        this(id, form, null);
    }

    public UploadProgressBar(String id, Form<?> form, FileUploadField uploadField) {
        super(id);
        this.uploadField = uploadField;
        if (uploadField != null) {
            uploadField.setOutputMarkupId(true);
        }
        this.form = (Form)Args.notNull(form, (String)"form");
        form.setOutputMarkupId(true);
        this.setRenderBodyOnly(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        Form<?> form = this.getCallbackForm();
        if (form != null) {
            form.setOutputMarkupId(true);
        }
        this.barDiv = this.newBarComponent("bar");
        this.add(new Component[]{this.barDiv});
        this.statusDiv = this.newStatusComponent("status");
        this.add(new Component[]{this.statusDiv});
    }

    protected MarkupContainer newStatusComponent(String id) {
        WebMarkupContainer status = new WebMarkupContainer(id);
        status.setOutputMarkupId(true);
        return status;
    }

    protected MarkupContainer newBarComponent(String id) {
        WebMarkupContainer bar = new WebMarkupContainer(id);
        bar.setOutputMarkupId(true);
        return bar;
    }

    protected ResourceReference getCss() {
        return CSS;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        CoreLibrariesContributor.contributeAjax((Application)this.getApplication(), (IHeaderResponse)response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
        ResourceReference css = this.getCss();
        if (css != null) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)css));
        }
        SharedResourceReference ref = new SharedResourceReference(RESOURCE_NAME);
        String uploadFieldId = this.uploadField == null ? "null" : "'" + this.uploadField.getMarkupId() + "'";
        String status = new StringResourceModel(RESOURCE_STARTING, (Component)this, null).getString();
        CharSequence url = this.form != null ? this.urlFor((ResourceReference)ref, UploadStatusResource.newParameter(this.getPage().getId())) : this.urlFor((ResourceReference)ref, UploadStatusResource.newParameter(this.uploadField.getMarkupId()));
        StringBuilder builder = new StringBuilder(128);
        Formatter formatter = new Formatter(builder);
        Form<?> form = this.getCallbackForm();
        formatter.format(this.getVarName() + " = new Wicket.WUPB(%s, '%s', '%s', '%s', %s, '%s', %s);", form != null ? "'" + form.getMarkupId() + "'" : "null", this.statusDiv.getMarkupId(), this.barDiv.getMarkupId(), url, uploadFieldId, status, this.getOnProgressUpdatedCallBack());
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)builder.toString()));
    }

    protected String getOnProgressUpdatedCallBack() {
        return "function(percent) {}";
    }

    private String getVarName() {
        return "window.upb_" + this.barDiv.getMarkupId();
    }

    public void start(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)(this.getVarName() + ".start();"));
    }

    private Form<?> getCallbackForm() {
        if (this.form == null) {
            return null;
        }
        return this.form.getRootForm();
    }

    public static final class ComponentInitializer
    implements IInitializer {
        public void init(Application application) {
            application.getSharedResources().add(RESOURCE_NAME, (IResource)new UploadStatusResource());
        }

        public String toString() {
            return "UploadProgressBar initializer";
        }

        public void destroy(Application application) {
        }
    }
}

