/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.crypt;

import java.io.Serializable;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.io.IClusterable;

public abstract class AbstractKeyInSessionCryptFactory<T extends IClusterable>
implements ICryptFactory {
    private static final MetaDataKey<Serializable> KEY = new MetaDataKey<Serializable>(){
        private static final long serialVersionUID = 1L;
    };

    @Override
    public ICrypt newCrypt() {
        Session session = Session.get();
        session.bind();
        IClusterable key = (IClusterable)session.getMetaData((MetaDataKey)KEY);
        if (key == null) {
            key = this.generateKey(session);
            session.setMetaData(KEY, key);
        }
        ICrypt crypt = this.createCrypt(key);
        return crypt;
    }

    protected abstract T generateKey(Session var1);

    protected abstract ICrypt createCrypt(T var1);
}

