package Daje::Controller::ToolsParameterValues;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Controller::Tools - Mojolicious Plugin
#
# SYNOPSIS
# ========
#
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Tools is a Mojolicious plugin.
#
# METHODS
# =======
#
# Register plugin in L<Mojolicious> application.
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.com
#

sub load_parameter_value ($self) {


    $self->render_later;
    # my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
    #     $self->req->headers->header('X-Token-Check')
    # );
    my $tools_projects_fkey = $self->param('tools_projects_fkey');
    my $tools_parameters_fkey = $self->param('tools_parameters_fkey');

    # my $setting = $self->param('setting');
    $self->tools_parameter_values->load_tools_parameters_values_project_parameter_fkey(
        $tools_projects_fkey, $tools_parameters_fkey
    )->then(sub($result) {
        $self->render(json => $result->{data});
    })->catch(sub($err) {
        $self->app->log->debug('Daje::Controller::ToolsParameterValues::load_parameter_value ' . $err);
        $self->render(json => { 'result' => 0, data => $err });
    })->wait;
}




1;

#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Controller::Tools - Mojolicious Plugin



=head1 SYNOPSIS






=head1 DESCRIPTION


Daje::Controller::Tools is a Mojolicious plugin.



=head1 REQUIRES

L<Data::Dumper> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS


Register plugin in L<Mojolicious> application.



=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.com



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

