/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ncx.NCXHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;
import java.io.InputStream;

public class NCXChecker
implements ContentChecker {
    OCFPackage ocf;
    Report report;
    String path;
    XRefChecker xrefChecker;
    EPUBVersion version;
    static XMLValidator ncxValidator = new XMLValidator("schema/20/rng/ncx.rng");
    static XMLValidator ncxSchematronValidator = new XMLValidator("schema/20/sch/ncx.sch");

    public NCXChecker(OCFPackage ocf, Report report, String path, XRefChecker xrefChecker, EPUBVersion version) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, "NCX file " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, 0, "NCX file " + this.path + " cannot be decrypted");
        } else {
            XMLParser ncxParser = null;
            InputStream in = null;
            NCXHandler ncxHandler = null;
            try {
                in = this.ocf.getInputStream(this.path);
                ncxParser = new XMLParser(in, this.path, "", this.report, this.version);
                ncxParser.addValidator(ncxValidator);
                ncxHandler = new NCXHandler(ncxParser, this.path, this.xrefChecker);
                ncxParser.addXMLHandler(ncxHandler);
                ncxParser.process();
                if (this.ocf.getUniqueIdentifier() != null && !this.ocf.getUniqueIdentifier().equals(ncxHandler.getUid())) {
                    this.report.warning(this.path, 0, 0, String.format(Messages.NCX_BAD_UID, ncxHandler.getUid(), this.ocf.getUniqueIdentifier()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            try {
                in = this.ocf.getInputStream(this.path);
                ncxParser = new XMLParser(this.ocf.getInputStream(this.path), this.path, "application/x-dtbncx+xml", this.report, this.version);
                ncxParser.addValidator(ncxSchematronValidator);
                ncxParser.process();
            }
            catch (Throwable t) {
                this.report.error(this.path, -1, 0, "Failed performing NCX Schematron tests: " + t.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

