/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEach
extends Instruction
implements ContextMappingFunction<Item>,
ContextSwitchingExpression {
    protected Expression select;
    protected Expression action;
    protected Expression threads;
    protected boolean containsTailCall;

    public ForEach(Expression select, Expression action) {
        this.select = select;
        this.action = action;
        this.containsTailCall = false;
        this.threads = null;
        this.adoptChildExpression(select);
        this.adoptChildExpression(action);
    }

    public ForEach(Expression select, Expression action, boolean containsTailCall, Expression threads) {
        this.select = select;
        this.action = action;
        this.containsTailCall = containsTailCall && action instanceof TailCallReturner;
        this.threads = threads;
        this.adoptChildExpression(select);
        this.adoptChildExpression(action);
    }

    @Override
    public int getInstructionNameCode() {
        return 151;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
    }

    @Override
    public Expression getControllingExpression() {
        return this.select;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public void setActionExpression(Expression action) {
        this.action = action;
    }

    @Override
    public Expression getControlledExpression() {
        return this.action;
    }

    public Expression getNumberOfThreadsExpression() {
        return this.threads;
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    @Override
    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.action = visitor.simplify(this.action);
        this.threads = visitor.simplify(this.threads);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.select.getItemType(th), false);
        this.action = visitor.typeCheck(this.action, cit);
        this.adoptChildExpression(this.action);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e2;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.action = this.action.optimize(visitor, new ExpressionVisitor.ContextItemType(this.select.getItemType(th), false));
        this.adoptChildExpression(this.action);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        PromotionOffer offer = new PromotionOffer(visitor.getConfiguration().obtainOptimizer());
        offer.action = 10;
        offer.promoteDocumentDependent = (this.select.getSpecialProperties() & 0x10000) != 0;
        offer.promoteXSLTFunctions = false;
        offer.containingExpression = this;
        offer.bindingList = new Binding[0];
        this.action = this.doPromotion(this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(offer.containingExpression, contextItemType);
        }
        if ((e2 = offer.containingExpression) != this) {
            return e2;
        }
        if (this.threads != null) {
            return visitor.getConfiguration().obtainOptimizer().generateMultithreadedInstruction(this);
        }
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        return this.action.addToPathMap(pathMap, target);
    }

    @Override
    public Expression copy() {
        return new ForEach(this.select.copy(), this.action.copy(), this.containsTailCall, this.threads);
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        return dependencies |= this.action.getDependencies() & 0xFFFFFFE1;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p |= this.action.getSpecialProperties() & 0x4000000;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        if (offer.action == 12 || offer.action == 15 || offer.action == 14) {
            this.action = this.doPromotion(this.action, offer);
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        if (this.threads == null) {
            return new PairIterator<Expression>(this.select, this.action);
        }
        return Arrays.asList(this.select, this.action, this.threads).iterator();
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        if (this.threads == null) {
            return new MonoIterator<Expression>(this.select);
        }
        return new PairIterator<Expression>(this.select, this.threads);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int getImplementationMethod() {
        return 30;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        SequenceIterator<? extends Item> iter = this.select.iterate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentTemplateRule(null);
        if (this.containsTailCall) {
            if (controller.isTracing()) {
                TraceListener listener = controller.getTraceListener();
                assert (listener != null);
                Item item = iter.next();
                if (item == null) {
                    return null;
                }
                listener.startCurrentItem(item);
                TailCall tc = ((TailCallReturner)((Object)this.action)).processLeavingTail(c2);
                listener.endCurrentItem(item);
                return tc;
            }
            Item item = iter.next();
            if (item == null) {
                return null;
            }
            return ((TailCallReturner)((Object)this.action)).processLeavingTail(c2);
        }
        if (controller.isTracing()) {
            Item item;
            TraceListener listener = controller.getTraceListener();
            assert (listener != null);
            while ((item = iter.next()) != null) {
                listener.startCurrentItem(item);
                this.action.process(c2);
                listener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = iter.next()) != null) {
                this.action.process(c2);
            }
        }
        return null;
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> master = this.select.iterate(context);
        XPathContextMinor c2 = context.newMinorContext();
        c2.setCurrentIterator(master);
        master = new ContextMappingIterator<Item>(this, c2);
        return master;
    }

    @Override
    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.action.iterate(context);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("forEach");
        this.explainThreads(out);
        this.select.explain(out);
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    protected void explainThreads(ExpressionPresenter out) {
    }
}

