/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

class MessageListenerProxy
extends SequenceWriter {
    private MessageListener listener;
    private boolean terminate;
    private int locationId = -1;

    protected MessageListenerProxy(MessageListener listener, PipelineConfiguration pipe) {
        super(pipe);
        this.listener = listener;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void startDocument(int properties) throws XPathException {
        this.terminate = (properties & 0x4000) != 0;
        this.locationId = -1;
        super.startDocument(properties);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (this.locationId == -1) {
            this.locationId = locationId;
        }
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void characters(CharSequence s, int locationId, int properties) throws XPathException {
        if (this.locationId == -1) {
            this.locationId = locationId;
        }
        super.characters(s, locationId, properties);
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (this.locationId == -1) {
            this.locationId = locationId;
        }
        super.append(item, locationId, copyNamespaces);
    }

    public void write(Item item) throws XPathException {
        ExpressionLocation loc = new ExpressionLocation();
        if (this.locationId != -1) {
            LocationProvider provider = this.getPipelineConfiguration().getLocationProvider();
            loc.setSystemId(provider.getSystemId(this.locationId));
            loc.setLineNumber(provider.getLineNumber(this.locationId));
        }
        this.listener.message(new XdmNode((NodeInfo)item), this.terminate, loc);
    }
}

