#!/usr/local/bin/perl -w

=head1 NAME

02source.t - testing of VCP::Source services

=cut

use strict ;

use Carp ;
use Test ;
use VCP::Source;

my $p ;

sub f {
   my @f = reverse( (localtime shift)[0..5] ) ;
   $f[0] += 1900 ;
   $f[1] ++ ; ## Month of year needs to be 1..12
   return sprintf( "%04d-%02d-%02d %02d:%02d:%02d", @f ) ;
}

sub pt {
   return f $p->parse_time( @_ );
}

my @tests = (
sub {
   $p = VCP::Source->new() ;
   ok ref $p, 'VCP::Source';
},

sub {
   $p->bootstrap( "foo" );
   ok join( " ", map "'$_'", $p->options_as_strings ), qr/'--bootstrap=foo'/;
},

sub { ok pt( "2000-01-01 00:00:00" ), "2000-01-01 00:00:00" },
sub { ok pt( "2000-01-01 00:00   " ), "2000-01-01 00:00:00" },
sub { ok pt( "2000-01-01         " ), "2000-01-01 00:00:00" },

sub { ok pt( "2000-01-01 12:00:00 AM" ), "2000-01-01 00:00:00" },
sub { ok pt( "2000-01-01 01:00:00 AM" ), "2000-01-01 01:00:00" },
sub { ok pt( "2000-01-01 11:00:00 AM" ), "2000-01-01 11:00:00" },
sub { ok pt( "2000-01-01 12:00:00 PM" ), "2000-01-01 12:00:00" },
sub { ok pt( "2000-01-01 01:00:00 PM" ), "2000-01-01 13:00:00" },
sub { ok pt( "2000-01-01 11:00:00 PM" ), "2000-01-01 23:00:00" },
sub { ok pt( "2000-01-01 12:00:00 A"  ), "2000-01-01 00:00:00" },
sub { ok pt( "2000-01-01 01:00:00 A"  ), "2000-01-01 01:00:00" },
sub { ok pt( "2000-01-01 11:00:00 A"  ), "2000-01-01 11:00:00" },
sub { ok pt( "2000-01-01 12:00:00 P"  ), "2000-01-01 12:00:00" },
sub { ok pt( "2000-01-01 01:00:00 P"  ), "2000-01-01 13:00:00" },
sub { ok pt( "2000-01-01 11:00:00 P"  ), "2000-01-01 23:00:00" },
sub { ok pt( "2000-01-01 12:00:00AM"  ), "2000-01-01 00:00:00" },
sub { ok pt( "2000-01-01 01:00:00AM"  ), "2000-01-01 01:00:00" },
sub { ok pt( "2000-01-01 11:00:00AM"  ), "2000-01-01 11:00:00" },
sub { ok pt( "2000-01-01 12:00:00PM"  ), "2000-01-01 12:00:00" },
sub { ok pt( "2000-01-01 01:00:00PM"  ), "2000-01-01 13:00:00" },
sub { ok pt( "2000-01-01 11:00:00PM"  ), "2000-01-01 23:00:00" },
sub { ok pt( "2000-01-01 12:00:00A"   ), "2000-01-01 00:00:00" },
sub { ok pt( "2000-01-01 01:00:00A"   ), "2000-01-01 01:00:00" },
sub { ok pt( "2000-01-01 11:00:00A"   ), "2000-01-01 11:00:00" },
sub { ok pt( "2000-01-01 12:00:00P"   ), "2000-01-01 12:00:00" },
sub { ok pt( "2000-01-01 01:00:00P"   ), "2000-01-01 13:00:00" },
sub { ok pt( "2000-01-01 11:00:00P"   ), "2000-01-01 23:00:00" },

) ;

plan tests => scalar( @tests ) ;

$_->() for @tests ;
