package Net::Amazon::EMR::StepStatus;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

subtype 'Net::Amazon::EMR::Type::StepStatus::State' => as 'Str' => where { m/^(?:PENDING | RUNNING | COMPLETED | CANCELLED | FAILED | INTERRUPTED)$/x };

has 'State' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::StepStatus::State',
                coerce => 1,
);

has 'StateChangeReason' => ( is => 'ro', 
                             isa => 'Net::Amazon::EMR::Type::StepStateChangeReason',
                             coerce => 1,
                         );

has 'Timeline' => ( is => 'ro', 
                    isa => 'Net::Amazon::EMR::Type::StepTimeline',
                    coerce => 1,
                );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::StepStatus

=head1 DESCRIPTION

Implements the StepStatus data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_StepStatus.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
