#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Aragami expansions:
# - Nightfall
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250707.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='aragami'
GAME_NAME='Aragami'

EXPANSION_ID='nightfall'
EXPANSION_NAME='Nightfall'

ARCHIVE_BASE_0_NAME='aragami_nightfall_dlc_en_gog_1_21278.sh'
ARCHIVE_BASE_0_MD5='40920a28f030147a524e5ac89e2cf14b'
ARCHIVE_BASE_0_SIZE='7387678'
ARCHIVE_BASE_0_VERSION='1.0-gog21278'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/aragami_nightfall'

CONTENT_PATH_DEFAULT='data/noarch/game'
## Content shared between the base game and the expansion.
CONTENT_GAME_MAIN_FILES='
Aragami_Data/globalgamemanagers
Aragami_Data/globalgamemanagers.assets
Aragami_Data/level2
Aragami_Data/level5
Aragami_Data/level6
Aragami_Data/level8
Aragami_Data/level11
Aragami_Data/level13
Aragami_Data/level14
Aragami_Data/level16
Aragami_Data/level18
Aragami_Data/level19
Aragami_Data/level19.resS
Aragami_Data/level20
Aragami_Data/level21
Aragami_Data/Managed/Assembly-CSharp.dll
Aragami_Data/resources.assets
Aragami_Data/Resources/unity_builtin_extra
Aragami_Data/sharedassets2.assets
Aragami_Data/sharedassets5.assets
Aragami_Data/sharedassets6.assets
Aragami_Data/sharedassets7.assets
Aragami_Data/sharedassets8.assets
Aragami_Data/sharedassets9.assets
Aragami_Data/sharedassets10.assets
Aragami_Data/sharedassets11.assets
Aragami_Data/sharedassets13.assets
Aragami_Data/sharedassets14.assets
Aragami_Data/sharedassets15.assets
Aragami_Data/sharedassets17.assets
Aragami_Data/sharedassets18.assets
Aragami_Data/sharedassets18.assets.resS
Aragami_Data/sharedassets19.assets
Aragami_Data/sharedassets19.assets.resS'
## Content specific to the expansion.
CONTENT_GAME_MAIN_FILES="$CONTENT_GAME_MAIN_FILES
Aragami_Data/level22
Aragami_Data/level23
Aragami_Data/level23.resS
Aragami_Data/sharedassets22.assets
Aragami_Data/sharedassets23.assets
Aragami_Data/sharedassets23.assets.resS"

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_PROVIDES="
${GAME_ID}-data-shared"
PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
