---
title: bibiman
section: 1
header: User Manual bibiman
footer: bibiman 0.19.1
date: 2025-12-26
---

# NAME

bibiman - TUI for interacting with BibLaTeX databases

# SYNOPSIS

**bibiman** [*OPTIONS*] [*POSITIONAL ARGUMENTS*]|[*SUBCOMMAND*]

# DESCRIPTION

bibiman is a simple terminal user interface for handling your BibLaTeX database
as part of a terminal-based scientific workflow. It provides a TUI for browsing,
searching, editing, and managing bibliography entries with Vim-like keybindings
and fuzzy search capabilities.

# OPTIONS

**-h**, **--help**
: Show this help and exit

**-v**, **--version**
: Show the version and exit

**-c**, **--config-file=<PATH>**
: Path to config file used for current session. Takes precedence over standard
  config file.

**-l**, **--log-file=<PATH>**
: Path to log file used for current session. Takes precedence over standard
  logging file.

**--light-terminal**
: Enable color mode for light terminal background

**--pdf-path=<PATH>**
: Use PDF files named by citekey at the given path and its subdirs as value for
  the \`file\` field of the entry matching the citekey for the current session.
  Does not overwrite or change the original file. (might not work with citekeys
  containing special chars)

**-C**, **--cli-only**
: Load only entries from the files/dirs set at the CLI. Ignore files from the
  config file.

# POSITIONAL ARGUMENTS

*FILE*
: Path to .bib file

*DIRECTORY*
: Path to directory containing .bib files

Both arguments can be passed multiple times.

# SUBCOMMANDS

Beside the TUI bibiman offers some CLI features which can be processed via
subcommands:

## format-citekeys

**bibiman** *format-citekeys* [*OPTIONS*] *--source=<SOURCE>*
[*--output=<TARGET>*]

This help describes the CLI usage for the citekey formatting functionality of
bibiman. The definition of patterns how the citekeys should be formatted must be
set in the config file. For further informations how to use this patterns etc.
see: https://codeberg.org/lukeflo/bibiman/src/branch/main/CITEKEYS.md

Possible options:

**--dry-run**
: Don't apply any changes to the named files. Instead print all old citekeys and
  the formatted strings that would have been applied in the format: old_key =>
  new_key

**-s, -f, --source=<PATH>, --file=<PATH>**
: The bibfile for which the citekey formatting should be processed. Takes a path
  as argument.

**-t, -o, --target=<PATH>, --output=<PATH>**
: The bibfile to which the updated content should be written. Takes a path as
  argument. If the file doesn't exist, it will be created. If the argument isn't
  used, the original file will be overwritten!

**-u, --update-attachments**
: When this option is set, bibiman will also rename all PDFs and notefiles
  following the bibiman citekey-basename scheme at the locations set in the
  config file. This option can break file paths. Try with --dry-run first!

# CONFIGURATION

bibiman can be configured through a config file. The standard location is:

> > $XDG_CONFIG_HOME/bibiman/bibiman.toml

Or as fallback:

> > $HOME/.config/bibiman/bibiman.toml

## General Configuration

For information on the values which can be set through the config file just run
`man 5 bibiman`.

# KEYBINDINGS

| Key                                      | Action                                                   |
| ---------------------------------------- | -------------------------------------------------------- |
| `?`                                      | Open help popup with keybindings                         |
| `j`, `k` \| `Down`, `Up`                 | Move down/up by 1                                        |
| `Ctrl-d`, `Ctrl-u`                       | Move down/up by 5                                        |
| `g`, `G`                                 | Go to first/last entry                                   |
| `h`, `k` \| `Left`, `Right`              | Select previous/next entry column                        |
| `s`                                      | Sort entries by current column (toggles)                 |
| `S`                                      | Sort entries by position in file                         |
| `PageDown`, `PageUp` \| `Alt-j`, `Alt-k` | Scroll Info window                                       |
| `y`                                      | Yank/copy field value of selected entry to clipboard     |
| `e`                                      | Open editor at selected entry                            |
| `a`                                      | Add entry through DOI                                    |
| `o`                                      | Open related PDF or URL/DOI                              |
| `n`                                      | Create new note file for selected entry                  |
| `TAB`                                    | Switch between entries and keywords                      |
| `/`, `Ctrl-f`                            | Enter search mode                                        |
| `Alt-/`, `Alt-f`                    | Select specific field to search                          |
| `Enter`                                  | Filter by selected keyword / Confirm search or selection |
| `ESC`                                    | Abort search / Reset current list                        |
| `q`, `Ctrl-c`                            | Quit TUI                                                 |

## Fast Selection Keys

o-o, o-l, o-n
: Directly open the first file|link|note for the selected entry

y-y
: Directly yank the citekey of the selected entry to the clipboard

# EXAMPLES

Open a single bib file:

> bibiman tests/biblatex-test.bib

Open multiple files:

> bibiman tests/multi-files/bibfile1.bib tests/multi-files/bibfile2.bib

Open directory containing bib files:

> bibiman tests/multi-files/

Mixed arguments:

> bibiman tests/biblatex-test.bib tests/multi-files/

Use custom config file:

> bibiman --config-file="/path/to/temporary/config" /path/to/bibfile.bib

# REPORTING BUGS

Report issues at: https://codeberg.org/lukeflo/bibiman/issues

# SEE ALSO

**bibiman**(5)

# AUTHOR

lukeflo \<lukeflo\_git@posteo.de>
