"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadCff1 = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const view_list_1 = require("../cff-index/view-list");
const subroutine_index_1 = require("../char-string/read/subroutine-index");
const read_1 = require("../context/read");
const top_1 = require("../dict/top");
const string_index_1 = require("../strings/string-index");
const cff1_header_1 = require("../structs/cff1-header");
const shared_1 = require("./shared");
exports.ReadCff1 = (0, bin_util_1.Read)((view, cfg, gOrd, coStat) => {
    const ctx = new read_1.CffReadContext(1, view.lift(0), coStat);
    if (!ctx.strings)
        throw errors_1.Errors.Cff.ShouldHaveStrings();
    const cff = new ot_glyphs_1.Cff.Table(1);
    const header = view.next(cff1_header_1.Cff1Header);
    const nameIndex = view.next(string_index_1.CffStringIndex, ctx);
    const topDictIndex = view.next(view_list_1.CffDeferIndex, ctx);
    const stringList = view.next(string_index_1.CffStringIndex, ctx);
    const gSubrs = view.next(subroutine_index_1.CffSubroutineIndex, ctx);
    errors_1.Assert.Cff.OnlyOneTopDictAllowed(nameIndex);
    errors_1.Assert.Cff.OnlyOneTopDictAllowed(topDictIndex);
    for (let sidT = 0; sidT < stringList.length; sidT++) {
        ctx.strings.putByStringIndexIndex(sidT, stringList[sidT]);
    }
    cff.postScriptFontName = nameIndex[0];
    const topDict = topDictIndex[0].view.next(top_1.CffTopDictIo, ctx, topDictIndex[0].size);
    (0, shared_1.readCffCommon)(cff, gOrd, topDict, ctx, gSubrs);
    (0, shared_1.cffCleanupUnusedData)(cff);
    return { cff, cffGlyphNaming: ctx.naming };
});
//# sourceMappingURL=read-cff1.js.map