"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeOtMetadata = exports.readOtMetadata = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ImpLib = require("@ot-builder/common-impl");
const errors_1 = require("@ot-builder/errors");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
const avar_1 = require("../avar");
const fvar_1 = require("../fvar");
const gasp_1 = require("../gasp");
const head_1 = require("../head");
const maxp_1 = require("../maxp");
const metric_head_1 = require("../metric-head");
const mvar_1 = require("../mvar");
const os2_1 = require("../os2");
const post_1 = require("../post");
function readOtMetadata(sfnt, cfg) {
    const bHead = sfnt.tables.get(ot_metadata_1.Head.Tag);
    if (!bHead)
        throw errors_1.Errors.MissingKeyTable(ot_metadata_1.Head.Tag);
    const head = new bin_util_1.BinaryView(bHead).next(head_1.HeadIo);
    const bMaxp = sfnt.tables.get(ot_metadata_1.Maxp.Tag);
    if (!bMaxp)
        throw errors_1.Errors.MissingKeyTable(ot_metadata_1.Maxp.Tag);
    const maxp = new bin_util_1.BinaryView(bMaxp).next(maxp_1.MaxpIo);
    const bFvar = sfnt.tables.get(ot_metadata_1.Fvar.Tag);
    const fvar = bFvar ? new bin_util_1.BinaryView(bFvar).next(fvar_1.FvarIo) : null;
    const bHhea = sfnt.tables.get(ot_metadata_1.MetricHead.TagHhea);
    const hhea = bHhea ? new bin_util_1.BinaryView(bHhea).next(metric_head_1.MetricHeadIo, false) : null;
    const bVhea = sfnt.tables.get(ot_metadata_1.MetricHead.TagVhea);
    const vhea = bVhea ? new bin_util_1.BinaryView(bVhea).next(metric_head_1.MetricHeadIo, true) : null;
    const bPost = sfnt.tables.get(ot_metadata_1.Post.Tag);
    const postResult = bPost ? new bin_util_1.BinaryView(bPost).next(post_1.PostAndNameIo) : null;
    const post = postResult ? postResult.post : null;
    const postGlyphNaming = postResult ? postResult.naming : null;
    const bOs2 = sfnt.tables.get(ot_metadata_1.Os2.Tag);
    const os2 = bOs2 ? new bin_util_1.BinaryView(bOs2).next(os2_1.Os2TableIo) : null;
    const bAvar = sfnt.tables.get(ot_metadata_1.Avar.Tag);
    const avar = bAvar && fvar ? new bin_util_1.BinaryView(bAvar).next(avar_1.AvarIo, fvar.getDesignSpace()) : null;
    const bGasp = sfnt.tables.get(ot_metadata_1.Gasp.Tag);
    const gasp = bGasp ? new bin_util_1.BinaryView(bGasp).next(gasp_1.GaspTableIo) : null;
    const md = { head, maxp, fvar, hhea, vhea, post, postGlyphNaming, os2, avar, gasp };
    const bMvar = sfnt.tables.get(mvar_1.MvarTag);
    if (fvar && bMvar) {
        new bin_util_1.BinaryView(bMvar).next(mvar_1.MvarTableIo, fvar.getDesignSpace(), md);
    }
    return md;
}
exports.readOtMetadata = readOtMetadata;
function writeOtMetadata(sink, cfg, md) {
    if (md.fvar) {
        const sfEmpty = new ImpLib.State(false);
        const bMvar = bin_util_1.Frag.packFrom(mvar_1.MvarTableIo, md.fvar.getDesignSpace(), md, sfEmpty);
        if (!sfEmpty.get())
            sink.add(mvar_1.MvarTag, bMvar);
    }
    if (md.gasp)
        sink.add(ot_metadata_1.Gasp.Tag, bin_util_1.Frag.packFrom(gasp_1.GaspTableIo, md.gasp));
    if (md.fvar && md.avar)
        sink.add(ot_metadata_1.Avar.Tag, bin_util_1.Frag.packFrom(avar_1.AvarIo, md.avar, md.fvar.getDesignSpace()));
    if (md.os2)
        sink.add(ot_metadata_1.Os2.Tag, bin_util_1.Frag.packFrom(os2_1.Os2TableIo, md.os2));
    if (md.post) {
        sink.add(ot_metadata_1.Post.Tag, bin_util_1.Frag.packFrom(post_1.PostAndNameIo, md.post, md.maxp.numGlyphs, md.postGlyphNaming));
    }
    if (md.vhea)
        sink.add(ot_metadata_1.MetricHead.TagVhea, bin_util_1.Frag.packFrom(metric_head_1.MetricHeadIo, md.vhea));
    if (md.hhea)
        sink.add(ot_metadata_1.MetricHead.TagHhea, bin_util_1.Frag.packFrom(metric_head_1.MetricHeadIo, md.hhea));
    if (md.fvar)
        sink.add(ot_metadata_1.Fvar.Tag, bin_util_1.Frag.packFrom(fvar_1.FvarIo, md.fvar));
    sink.add(ot_metadata_1.Maxp.Tag, bin_util_1.Frag.packFrom(maxp_1.MaxpIo, md.maxp));
    sink.add(ot_metadata_1.Head.Tag, bin_util_1.Frag.packFrom(head_1.HeadIo, md.head));
}
exports.writeOtMetadata = writeOtMetadata;
//# sourceMappingURL=index.js.map