"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MathValueRecord = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const variance_1 = require("@ot-builder/variance");
const device_table_1 = require("./device-table");
// MATH currently doesn't have variation
exports.MathValueRecord = {
    ...(0, bin_util_1.Read)(bp => {
        const value = bp.int16();
        const pDeviceTable = bp.ptr16Nullable();
        if (!pDeviceTable)
            return { value };
        const device = pDeviceTable.next(device_table_1.DeviceTable);
        if (device.deviceDeltas) {
            return { value, device: device.deviceDeltas };
        }
        else {
            return { value };
        }
    }),
    ...(0, bin_util_1.Write)((fr, v) => {
        fr.int16(variance_1.OtVar.Ops.originOf(v.value));
        if (v.device) {
            fr.ptr16New().push(device_table_1.DeviceTable, { variation: 0, deviceDeltas: v.device });
        }
        else {
            fr.ptr16(null);
        }
    })
};
//# sourceMappingURL=math-value-record.js.map