// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/cloudcontrolspartner/v1beta/customer_workloads.proto

package cloudcontrolspartnerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported Assured Workloads Partners.
type Workload_Partner int32

const (
	// Unknown Partner.
	Workload_PARTNER_UNSPECIFIED Workload_Partner = 0
	// Enum representing S3NS (Thales) partner.
	Workload_PARTNER_LOCAL_CONTROLS_BY_S3NS Workload_Partner = 1
	// Enum representing T_SYSTEM (TSI) partner.
	Workload_PARTNER_SOVEREIGN_CONTROLS_BY_T_SYSTEMS Workload_Partner = 2
	// Enum representing SIA_MINSAIT (Indra) partner.
	Workload_PARTNER_SOVEREIGN_CONTROLS_BY_SIA_MINSAIT Workload_Partner = 3
	// Enum representing PSN (TIM) partner.
	Workload_PARTNER_SOVEREIGN_CONTROLS_BY_PSN Workload_Partner = 4
	// Enum representing CNTXT (Kingdom of Saudi Arabia) partner.
	Workload_PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT Workload_Partner = 6
	// Enum representing CNXT (Kingdom of Saudi Arabia) partner offering without
	// EKM provisioning.
	Workload_PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT_NO_EKM Workload_Partner = 7
)

// Enum value maps for Workload_Partner.
var (
	Workload_Partner_name = map[int32]string{
		0: "PARTNER_UNSPECIFIED",
		1: "PARTNER_LOCAL_CONTROLS_BY_S3NS",
		2: "PARTNER_SOVEREIGN_CONTROLS_BY_T_SYSTEMS",
		3: "PARTNER_SOVEREIGN_CONTROLS_BY_SIA_MINSAIT",
		4: "PARTNER_SOVEREIGN_CONTROLS_BY_PSN",
		6: "PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT",
		7: "PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT_NO_EKM",
	}
	Workload_Partner_value = map[string]int32{
		"PARTNER_UNSPECIFIED":                        0,
		"PARTNER_LOCAL_CONTROLS_BY_S3NS":             1,
		"PARTNER_SOVEREIGN_CONTROLS_BY_T_SYSTEMS":    2,
		"PARTNER_SOVEREIGN_CONTROLS_BY_SIA_MINSAIT":  3,
		"PARTNER_SOVEREIGN_CONTROLS_BY_PSN":          4,
		"PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT":        6,
		"PARTNER_SOVEREIGN_CONTROLS_BY_CNTXT_NO_EKM": 7,
	}
)

func (x Workload_Partner) Enum() *Workload_Partner {
	p := new(Workload_Partner)
	*p = x
	return p
}

func (x Workload_Partner) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_Partner) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_enumTypes[0].Descriptor()
}

func (Workload_Partner) Type() protoreflect.EnumType {
	return &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_enumTypes[0]
}

func (x Workload_Partner) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_Partner.Descriptor instead.
func (Workload_Partner) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{0, 0}
}

// Enum for possible onboarding steps.
type WorkloadOnboardingStep_Step int32

const (
	// Unspecified step.
	WorkloadOnboardingStep_STEP_UNSPECIFIED WorkloadOnboardingStep_Step = 0
	// EKM Provisioned step.
	WorkloadOnboardingStep_EKM_PROVISIONED WorkloadOnboardingStep_Step = 1
	// Signed Access Approval step.
	WorkloadOnboardingStep_SIGNED_ACCESS_APPROVAL_CONFIGURED WorkloadOnboardingStep_Step = 2
)

// Enum value maps for WorkloadOnboardingStep_Step.
var (
	WorkloadOnboardingStep_Step_name = map[int32]string{
		0: "STEP_UNSPECIFIED",
		1: "EKM_PROVISIONED",
		2: "SIGNED_ACCESS_APPROVAL_CONFIGURED",
	}
	WorkloadOnboardingStep_Step_value = map[string]int32{
		"STEP_UNSPECIFIED":                  0,
		"EKM_PROVISIONED":                   1,
		"SIGNED_ACCESS_APPROVAL_CONFIGURED": 2,
	}
)

func (x WorkloadOnboardingStep_Step) Enum() *WorkloadOnboardingStep_Step {
	p := new(WorkloadOnboardingStep_Step)
	*p = x
	return p
}

func (x WorkloadOnboardingStep_Step) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadOnboardingStep_Step) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_enumTypes[1].Descriptor()
}

func (WorkloadOnboardingStep_Step) Type() protoreflect.EnumType {
	return &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_enumTypes[1]
}

func (x WorkloadOnboardingStep_Step) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadOnboardingStep_Step.Descriptor instead.
func (WorkloadOnboardingStep_Step) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{5, 0}
}

// Contains metadata around the [Workload
// resource](https://cloud.google.com/assured-workloads/docs/reference/rest/Shared.Types/Workload)
// in the Assured Workloads API.
type Workload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Format:
	// organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Folder id this workload is associated with
	FolderId int64 `protobuf:"varint,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Output only. Time the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The name of container folder of the assured workload
	Folder string `protobuf:"bytes,4,opt,name=folder,proto3" json:"folder,omitempty"`
	// Container for workload onboarding steps.
	WorkloadOnboardingState *WorkloadOnboardingState `protobuf:"bytes,5,opt,name=workload_onboarding_state,json=workloadOnboardingState,proto3" json:"workload_onboarding_state,omitempty"`
	// Indicates whether a workload is fully onboarded.
	IsOnboarded bool `protobuf:"varint,6,opt,name=is_onboarded,json=isOnboarded,proto3" json:"is_onboarded,omitempty"`
	// The project id of the key management project for the workload
	KeyManagementProjectId string `protobuf:"bytes,7,opt,name=key_management_project_id,json=keyManagementProjectId,proto3" json:"key_management_project_id,omitempty"`
	// The Google Cloud location of the workload
	Location string `protobuf:"bytes,8,opt,name=location,proto3" json:"location,omitempty"`
	// Partner associated with this workload.
	Partner Workload_Partner `protobuf:"varint,9,opt,name=partner,proto3,enum=google.cloud.cloudcontrolspartner.v1beta.Workload_Partner" json:"partner,omitempty"`
}

func (x *Workload) Reset() {
	*x = Workload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload) ProtoMessage() {}

func (x *Workload) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload.ProtoReflect.Descriptor instead.
func (*Workload) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{0}
}

func (x *Workload) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Workload) GetFolderId() int64 {
	if x != nil {
		return x.FolderId
	}
	return 0
}

func (x *Workload) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Workload) GetFolder() string {
	if x != nil {
		return x.Folder
	}
	return ""
}

func (x *Workload) GetWorkloadOnboardingState() *WorkloadOnboardingState {
	if x != nil {
		return x.WorkloadOnboardingState
	}
	return nil
}

func (x *Workload) GetIsOnboarded() bool {
	if x != nil {
		return x.IsOnboarded
	}
	return false
}

func (x *Workload) GetKeyManagementProjectId() string {
	if x != nil {
		return x.KeyManagementProjectId
	}
	return ""
}

func (x *Workload) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Workload) GetPartner() Workload_Partner {
	if x != nil {
		return x.Partner
	}
	return Workload_PARTNER_UNSPECIFIED
}

// Request to list customer workloads.
type ListWorkloadsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource
	// Format:
	// organizations/{organization}/locations/{location}/customers/{customer}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of workloads to return. The service may return fewer
	// than this value. If unspecified, at most 500 workloads will be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListWorkloads` call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListWorkloadsRequest) Reset() {
	*x = ListWorkloadsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadsRequest) ProtoMessage() {}

func (x *ListWorkloadsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkloadsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{1}
}

func (x *ListWorkloadsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkloadsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkloadsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkloadsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListWorkloadsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for list customer workloads requests.
type ListWorkloadsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of customer workloads
	Workloads []*Workload `protobuf:"bytes,1,rep,name=workloads,proto3" json:"workloads,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkloadsResponse) Reset() {
	*x = ListWorkloadsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkloadsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadsResponse) ProtoMessage() {}

func (x *ListWorkloadsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkloadsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{2}
}

func (x *ListWorkloadsResponse) GetWorkloads() []*Workload {
	if x != nil {
		return x.Workloads
	}
	return nil
}

func (x *ListWorkloadsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkloadsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a customer workload.
type GetWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkloadRequest) Reset() {
	*x = GetWorkloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkloadRequest) ProtoMessage() {}

func (x *GetWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkloadRequest.ProtoReflect.Descriptor instead.
func (*GetWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{3}
}

func (x *GetWorkloadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Container for workload onboarding steps.
type WorkloadOnboardingState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of workload onboarding steps.
	OnboardingSteps []*WorkloadOnboardingStep `protobuf:"bytes,1,rep,name=onboarding_steps,json=onboardingSteps,proto3" json:"onboarding_steps,omitempty"`
}

func (x *WorkloadOnboardingState) Reset() {
	*x = WorkloadOnboardingState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadOnboardingState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadOnboardingState) ProtoMessage() {}

func (x *WorkloadOnboardingState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadOnboardingState.ProtoReflect.Descriptor instead.
func (*WorkloadOnboardingState) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{4}
}

func (x *WorkloadOnboardingState) GetOnboardingSteps() []*WorkloadOnboardingStep {
	if x != nil {
		return x.OnboardingSteps
	}
	return nil
}

// Container for workload onboarding information.
type WorkloadOnboardingStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The onboarding step.
	Step WorkloadOnboardingStep_Step `protobuf:"varint,1,opt,name=step,proto3,enum=google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep_Step" json:"step,omitempty"`
	// The starting time of the onboarding step.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The completion time of the onboarding step.
	CompletionTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=completion_time,json=completionTime,proto3" json:"completion_time,omitempty"`
	// Output only. The completion state of the onboarding step.
	CompletionState CompletionState `protobuf:"varint,4,opt,name=completion_state,json=completionState,proto3,enum=google.cloud.cloudcontrolspartner.v1beta.CompletionState" json:"completion_state,omitempty"`
}

func (x *WorkloadOnboardingStep) Reset() {
	*x = WorkloadOnboardingStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkloadOnboardingStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadOnboardingStep) ProtoMessage() {}

func (x *WorkloadOnboardingStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadOnboardingStep.ProtoReflect.Descriptor instead.
func (*WorkloadOnboardingStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP(), []int{5}
}

func (x *WorkloadOnboardingStep) GetStep() WorkloadOnboardingStep_Step {
	if x != nil {
		return x.Step
	}
	return WorkloadOnboardingStep_STEP_UNSPECIFIED
}

func (x *WorkloadOnboardingStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *WorkloadOnboardingStep) GetCompletionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompletionTime
	}
	return nil
}

func (x *WorkloadOnboardingStep) GetCompletionState() CompletionState {
	if x != nil {
		return x.CompletionState
	}
	return CompletionState_COMPLETION_STATE_UNSPECIFIED
}

var File_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto protoreflect.FileDescriptor

var file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDesc = []byte{
	0x0a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbf, 0x07, 0x0a, 0x08,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0x7d, 0x0a, 0x19, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6f,
	0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x17, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x6f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x65,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x4f, 0x6e, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x19, 0x6b, 0x65, 0x79, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x6b, 0x65, 0x79, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x07, 0x70,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x2e, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x07, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x22, 0xa2, 0x02, 0x0a, 0x07, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x12, 0x17, 0x0a,
	0x13, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45,
	0x52, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x53,
	0x5f, 0x42, 0x59, 0x5f, 0x53, 0x33, 0x4e, 0x53, 0x10, 0x01, 0x12, 0x2b, 0x0a, 0x27, 0x50, 0x41,
	0x52, 0x54, 0x4e, 0x45, 0x52, 0x5f, 0x53, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x49, 0x47, 0x4e, 0x5f,
	0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x53, 0x5f, 0x42, 0x59, 0x5f, 0x54, 0x5f, 0x53, 0x59,
	0x53, 0x54, 0x45, 0x4d, 0x53, 0x10, 0x02, 0x12, 0x2d, 0x0a, 0x29, 0x50, 0x41, 0x52, 0x54, 0x4e,
	0x45, 0x52, 0x5f, 0x53, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x49, 0x47, 0x4e, 0x5f, 0x43, 0x4f, 0x4e,
	0x54, 0x52, 0x4f, 0x4c, 0x53, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x49, 0x41, 0x5f, 0x4d, 0x49, 0x4e,
	0x53, 0x41, 0x49, 0x54, 0x10, 0x03, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45,
	0x52, 0x5f, 0x53, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x49, 0x47, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x52, 0x4f, 0x4c, 0x53, 0x5f, 0x42, 0x59, 0x5f, 0x50, 0x53, 0x4e, 0x10, 0x04, 0x12, 0x27, 0x0a,
	0x23, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x5f, 0x53, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x49,
	0x47, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x53, 0x5f, 0x42, 0x59, 0x5f, 0x43,
	0x4e, 0x54, 0x58, 0x54, 0x10, 0x06, 0x12, 0x2e, 0x0a, 0x2a, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45,
	0x52, 0x5f, 0x53, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x49, 0x47, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x52, 0x4f, 0x4c, 0x53, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x4e, 0x54, 0x58, 0x54, 0x5f, 0x4e, 0x4f,
	0x5f, 0x45, 0x4b, 0x4d, 0x10, 0x07, 0x3a, 0xa4, 0x01, 0xea, 0x41, 0xa0, 0x01, 0x0a, 0x2c, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x5b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x7b, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x7d, 0x2a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x32, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0xdd, 0x01,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72,
	0x74, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb3, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x09,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x5e, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a,
	0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61,
	0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x17, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x6b, 0x0a, 0x10, 0x6f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x6e, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x52, 0x0f, 0x6f, 0x6e, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x73, 0x22, 0xb8, 0x03, 0x0a,
	0x16, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x12, 0x59, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x04, 0x73, 0x74,
	0x65, 0x70, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x69, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x58, 0x0a,
	0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x45, 0x50, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x45,
	0x4b, 0x4d, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x25, 0x0a, 0x21, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49,
	0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x02, 0x42, 0xae, 0x02, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x16, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x60, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x73, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca,
	0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescOnce sync.Once
	file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescData = file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDesc
)

func file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescGZIP() []byte {
	file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescOnce.Do(func() {
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescData)
	})
	return file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDescData
}

var file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_goTypes = []interface{}{
	(Workload_Partner)(0),            // 0: google.cloud.cloudcontrolspartner.v1beta.Workload.Partner
	(WorkloadOnboardingStep_Step)(0), // 1: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep.Step
	(*Workload)(nil),                 // 2: google.cloud.cloudcontrolspartner.v1beta.Workload
	(*ListWorkloadsRequest)(nil),     // 3: google.cloud.cloudcontrolspartner.v1beta.ListWorkloadsRequest
	(*ListWorkloadsResponse)(nil),    // 4: google.cloud.cloudcontrolspartner.v1beta.ListWorkloadsResponse
	(*GetWorkloadRequest)(nil),       // 5: google.cloud.cloudcontrolspartner.v1beta.GetWorkloadRequest
	(*WorkloadOnboardingState)(nil),  // 6: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingState
	(*WorkloadOnboardingStep)(nil),   // 7: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep
	(*timestamppb.Timestamp)(nil),    // 8: google.protobuf.Timestamp
	(CompletionState)(0),             // 9: google.cloud.cloudcontrolspartner.v1beta.CompletionState
}
var file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_depIdxs = []int32{
	8, // 0: google.cloud.cloudcontrolspartner.v1beta.Workload.create_time:type_name -> google.protobuf.Timestamp
	6, // 1: google.cloud.cloudcontrolspartner.v1beta.Workload.workload_onboarding_state:type_name -> google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingState
	0, // 2: google.cloud.cloudcontrolspartner.v1beta.Workload.partner:type_name -> google.cloud.cloudcontrolspartner.v1beta.Workload.Partner
	2, // 3: google.cloud.cloudcontrolspartner.v1beta.ListWorkloadsResponse.workloads:type_name -> google.cloud.cloudcontrolspartner.v1beta.Workload
	7, // 4: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingState.onboarding_steps:type_name -> google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep
	1, // 5: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep.step:type_name -> google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep.Step
	8, // 6: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep.start_time:type_name -> google.protobuf.Timestamp
	8, // 7: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep.completion_time:type_name -> google.protobuf.Timestamp
	9, // 8: google.cloud.cloudcontrolspartner.v1beta.WorkloadOnboardingStep.completion_state:type_name -> google.cloud.cloudcontrolspartner.v1beta.CompletionState
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_init() }
func file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_init() {
	if File_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto != nil {
		return
	}
	file_google_cloud_cloudcontrolspartner_v1beta_completion_state_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkloadsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadOnboardingState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkloadOnboardingStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_goTypes,
		DependencyIndexes: file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_depIdxs,
		EnumInfos:         file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_enumTypes,
		MessageInfos:      file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_msgTypes,
	}.Build()
	File_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto = out.File
	file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_rawDesc = nil
	file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_goTypes = nil
	file_google_cloud_cloudcontrolspartner_v1beta_customer_workloads_proto_depIdxs = nil
}
