# File: makefile.defs.linux.pulse-gcc.BE
# System: Linux
# David Weenink and Paul Boersma, 29 December 2025

CC = gcc
CXX = g++
LINK = $(CXX)

PKG_CONFIG ?= pkg-config

COMMONFLAGS = -DUNIX -Dlinux -DALSA -DJACK -DHAVE_PULSEAUDIO \
	-DWORDS_BIGENDIAN=1 -DPA_BIG_ENDIAN \
	-D_FILE_OFFSET_BITS=64 `$(PKG_CONFIG) --cflags gtk+-3.0` \
	-Wreturn-type -Wunused -Wunused-parameter -Wuninitialized -O3 -g1 -pthread

CFLAGS = -std=gnu99 $(COMMONFLAGS) -Werror=missing-prototypes -Werror=implicit

CXXFLAGS = -std=c++17 $(COMMONFLAGS) -Wshadow

EXECUTABLE = praat

LIBS = `$(PKG_CONFIG) --libs gtk+-3.0 jack` -no-pie -lm -lpulse -lasound -lpthread

AR = ar
RANLIB = ls
ICON =
MAIN_ICON =

INSTALL = install -p praat /usr/local/bin
