% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{flextable}
\alias{flextable}
\alias{qflextable}
\title{Create a flextable from a data frame}
\usage{
flextable(
  data,
  col_keys = names(data),
  cwidth = 0.75,
  cheight = 0.25,
  defaults = list(),
  theme_fun = theme_booktabs,
  use_labels = TRUE
)

qflextable(data)
}
\arguments{
\item{data}{dataset}

\item{col_keys}{columns names/keys to display. If some column names are not in
the dataset, they will be added as blank columns by default.}

\item{cwidth, cheight}{initial width and height to use for cell sizes in inches.}

\item{defaults, theme_fun}{deprecated, use \code{\link[=set_flextable_defaults]{set_flextable_defaults()}} instead.}

\item{use_labels}{Logical; if TRUE, any column labels or value labels
present in the dataset will be used for display purposes. Defaults
to TRUE.}
}
\description{
Create a flextable object with function \code{flextable}.

\code{flextable} are designed to make tabular reporting easier for
R users. Functions are available to let you format text, paragraphs and cells;
table cells can be merge vertically or horizontally, row headers can easily
be defined, rows heights and columns widths can be manually set or automatically
computed.

If working with 'R Markdown' documents, you should read about knitr
chunk options in \code{\link[=knit_print.flextable]{knit_print.flextable()}} and about setting
default values with \code{\link[=set_flextable_defaults]{set_flextable_defaults()}}.
}
\section{Reuse frequently used parameters}{


Some default formatting properties are automatically
applied to every flextable you produce.

It is highly recommended to use this function because
its use will minimize the code. For example, instead of
calling the \code{fontsize()} function over and over again for
each new flextable, set the font size default value by
calling (before creating the flextables)
\code{set_flextable_defaults(font.size = 11)}. This is also
a simple way to have homogeneous arrays and make the
documents containing them easier to read.

You can change these default values with function
\code{\link[=set_flextable_defaults]{set_flextable_defaults()}}. You can reset them
with function \code{\link[=init_flextable_defaults]{init_flextable_defaults()}}. You
can access these values by calling \code{\link[=get_flextable_defaults]{get_flextable_defaults()}}.
}

\section{new lines and tabulations}{


The 'flextable' package will translate for you
the new lines expressed in the form \verb{\\n} and
the tabs expressed in the form \verb{\\t}.

The new lines will be transformed into "soft-return",
that is to say a simple carriage return and not a
new paragraph.

Tabs are different depending on the output format:
\itemize{
\item HTML is using entity \emph{em space}
\item Word - a Word 'tab' element
\item PowerPoint - a PowerPoint 'tab' element
\item latex - tag "\\quad "
}
}

\section{flextable parts}{


A \code{flextable} is made of 3 parts: header, body and footer.

Most functions have an argument named \code{part} that will be used
to specify what part of of the table should be modified.
}

\section{qflextable}{

\code{qflextable} is a convenient tool to produce quickly
a flextable for reporting where layout is fixed (see
\code{\link[=set_table_properties]{set_table_properties()}}) and columns
widths are adjusted with \code{\link[=autofit]{autofit()}}.
}

\examples{
ft <- flextable(head(mtcars))
ft
}
\seealso{
\code{\link[=style]{style()}}, \code{\link[=autofit]{autofit()}}, \code{\link[=theme_booktabs]{theme_booktabs()}}, \code{\link[=knit_print.flextable]{knit_print.flextable()}},
\code{\link[=compose]{compose()}}, \code{\link[=footnote]{footnote()}}, \code{\link[=set_caption]{set_caption()}}
}
