% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree}
\alias{tree}
\title{Pretty tree-like object printing}
\usage{
tree(
  x,
  ...,
  index_unnamed = FALSE,
  max_depth = 10L,
  max_length = 1000L,
  max_vec_len = 10L,
  show_environments = TRUE,
  hide_scalar_types = TRUE,
  val_printer = crayon::blue,
  class_printer = crayon::silver,
  show_attributes = FALSE,
  remove_newlines = TRUE,
  tree_chars = box_chars()
)
}
\arguments{
\item{x}{A tree like object (list, etc.)}

\item{...}{Ignored (used to force use of names)}

\item{index_unnamed}{Should children of containers without names have indices
used as stand-in?}

\item{max_depth}{How far down the tree structure should be printed. E.g. \code{1}
means only direct children of the root element will be shown. Useful for
very deep lists.}

\item{max_length}{How many elements should be printed? This is useful in case
you try and print an object with 100,000 items in it.}

\item{max_vec_len}{How many elements should be printed for vectors?}

\item{show_environments}{Should environments be treated like normal lists and
recursed into?}

\item{hide_scalar_types}{Should atomic scalars be printed with type and
length like vectors? E.g. \code{x <- "a"} would be shown as \verb{x<char [1]>: "a"}
instead of \code{x: "a"}.}

\item{val_printer}{Function that values get passed to before being drawn to
screen. Can be used to color or generally style output.}

\item{class_printer}{Same as \code{val_printer} but for the the class types of
non-atomic tree elements.}

\item{show_attributes}{Should attributes be printed as a child of the list or
avoided?}

\item{remove_newlines}{Should character strings with newlines in them have
the newlines removed? Not doing so will mess up the vertical flow of the
tree but may be desired for some use-cases if newline structure is
important to understanding object state.}

\item{tree_chars}{List of box characters used to construct tree. Needs
elements \verb{$h} for horizontal bar, \verb{$hd} for dotted horizontal bar, \verb{$v} for
vertical bar, \verb{$vd} for dotted vertical bar, \verb{$l} for l-bend, and \verb{$j} for
junction (or middle child).}
}
\value{
console output of structure
}
\description{
A cleaner and easier to read replacement for \code{str} for nested list-like
objects
}
\examples{

x <- list(
  list(id = "a", val = 2),
  list(
    id = "b",
    val = 1,
    children = list(
      list(id = "b1", val = 2.5),
      list(
        id = "b2",
        val = 8,
        children = list(
          list(id = "b21", val = 4)
        )
      )
    )
  ),
  list(
    id = "c",
    val = 8,
    children = list(
      list(id = "c1"),
      list(id = "c2", val = 1)
    )
  )
)

# Basic usage
tree(x)

# Even cleaner output can be achieved by not printing indices
tree(x, index_unnamed = FALSE)

# Limit depth if object is potentially very large
tree(x, max_depth = 2)

# You can customize how the values and classes are printed if desired
tree(x, val_printer = function(x) {
  paste0("_", x, "_")
})
}
