---
layout: post
title: Polyglot 1.10 - mejoras en i18n_headers
lang: es
description: Lanzamiento de Jekyll Polyglot 1.10.0, con mejoras en la generación SEO al usar el plugin i18n_headers
---

Jekyll-Polyglot 1.10 ya está disponible. Presenta grandes mejoras y cambios en el plugin liquid `i18n_headers` para SEO, y pequeños ajustes para la idempotencia en compilaciones paralelas. Las contribuciones de la comunidad y Vibe Coding ayudaron en gran parte de las características, pruebas y redacción de esta versión.

## Mejoras en i18n_headers

El plugin `i18n_headers` ahora tiene capacidades extendidas en esta versión:

* Añade `<link rel="canonical" ...>` para cada idioma de la página, asegurando que el indexado sea único en todos los sitios.
* Añade `<link rel="alternate" hreflang="x-default" ...>` para apuntar a la versión en el idioma predeterminado cuando el navegador no solicita un idioma específico.
* Define correctamente `<link rel="alternate" hreflang="...">` para páginas y posts en colecciones con permalinks personalizados.
* La URL predeterminada ahora incluirá `site.baseUrl` si está definido.

Esto también corrige un error que causaba que la relativización de URLs absolutas alterara estas etiquetas involuntariamente.

## Contribuciones vibe-coded

El uso de ciertas herramientas de [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) ayudó a encontrar, medir y verificar correcciones y características para este lanzamiento. Es un enfoque nuevo para el desarrollo de software, y permitió crear avanzadas pruebas en Ruby para código de plugins de Jekyll ejecutándose en muchos idiomas del sitio construido.

Las pruebas escritas con vibe coding ayudaron a mantener una alta cobertura de pruebas y a añadir características complejas con confianza. Garantizar la automatización de pruebas permitió construir correctamente características complicadas.

Además, las herramientas de vibe coding ayudaron a traducir esta entrada de blog a muchos idiomas.

## Contribuciones de la comunidad

Jekyll-Polyglot ha sido apoyado por personas. La documentación en lenguas humanas es aportada por personas que desean ver este plugin documentado en su lengua materna. Las personas que contribuyen con correcciones y documentación han ayudado a que este plugin alcance miles de descargas por versión. La programación asistida por IA, en mis manos o en las tuyas, dará forma al software que usamos y a los muchos idiomas en los que escribimos y hablamos. 

## ruby >= 3.1 requerido

Las actualizaciones de seguridad continuas de las dependencias de compilación de jekyll-polyglot requirieron una actualización importante a ruby 3.1. Esto puede afectar a los sistemas de compilación que generan su documentación con jekyll-polyglot. Ahora es un buen momento para actualizar a la última versión principal de ruby. Avísanos si estos cambios causan complicaciones con las compilaciones de jekyll. 