/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.time.Delta;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PrivacyPolicy {
    private int yearsInfoIsPrivate;
    private boolean infoOfAliveIsPrivate;
    private String tagMarkingPrivate;
    private Map<String, String> privateEvents = new TreeMap<String, String>();
    private boolean infoOfDeceasedIsPublic;
    private Set<Entity> privateYearsEntities = new HashSet<Entity>();
    private Set<Entity> aliveEntities = new HashSet<Entity>();
    private int yearsIndiCanBeAlive = 130;

    public PrivacyPolicy(int yearsInfoIsPrivate, String tagMarkingPrivate, boolean infoOfAliveIsPrivate, Map<String, String> privateEvents, boolean infoOfDeceasedIsPublic) {
        this.yearsInfoIsPrivate = Math.max(yearsInfoIsPrivate, 0);
        this.tagMarkingPrivate = tagMarkingPrivate == null || tagMarkingPrivate.length() == 0 ? null : tagMarkingPrivate;
        this.infoOfAliveIsPrivate = infoOfAliveIsPrivate;
        this.privateEvents = privateEvents;
        this.infoOfDeceasedIsPublic = infoOfDeceasedIsPublic;
    }

    public boolean isPrivate(Property prop) {
        if (this.infoOfDeceasedIsPublic && this.isInfoOfDeceased(prop)) {
            return false;
        }
        if (this.yearsInfoIsPrivate > 0 && this.isWithinPrivateYears(prop)) {
            return true;
        }
        if (this.infoOfAliveIsPrivate && this.isInfoOfAlive(prop)) {
            return true;
        }
        if (this.privateEvents != null && this.isPrivateEvent(prop)) {
            return true;
        }
        return this.tagMarkingPrivate != null && this.hasTagMarkingPrivate(prop);
    }

    private boolean isWithinPrivateYears(Property prop) {
        if (prop == null) {
            return false;
        }
        Entity ent = prop.getEntity();
        if (this.privateYearsEntities.contains(ent)) {
            return true;
        }
        if (ent instanceof Indi || ent instanceof Fam) {
            if (this.hasPrivateYearsDate((Property)ent)) {
                this.privateYearsEntities.add(ent);
                return true;
            }
        } else {
            List<Entity> list = this.getRelatedPeople(ent);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (this.privateYearsEntities.contains(entity)) {
                        return true;
                    }
                    if (!this.hasPrivateYearsDate((Property)entity)) continue;
                    this.privateYearsEntities.add(entity);
                    this.privateYearsEntities.add(ent);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInfoOfAlive(Property prop) {
        if (prop == null) {
            return false;
        }
        Entity ent = prop.getEntity();
        if (this.aliveEntities.contains(ent)) {
            return true;
        }
        if (ent instanceof Indi) {
            if (this.isAlive((Indi)ent)) {
                this.aliveEntities.add(ent);
                return true;
            }
        } else {
            if (ent instanceof Fam) {
                Indi husband = ((Fam)ent).getHusband();
                if (husband != null && this.isAlive(husband)) {
                    this.aliveEntities.add((Entity)husband);
                    this.aliveEntities.add(ent);
                    return true;
                }
                Indi wife = ((Fam)ent).getWife();
                if (wife != null && this.isAlive(wife)) {
                    this.aliveEntities.add((Entity)wife);
                    this.aliveEntities.add(ent);
                    return true;
                }
                return false;
            }
            List<Entity> list = this.getRelatedPeople(ent);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (this.aliveEntities.contains(entity)) {
                        return true;
                    }
                    if (entity instanceof Indi && this.isAlive((Indi)entity)) {
                        this.aliveEntities.add(entity);
                        this.aliveEntities.add(ent);
                        return true;
                    }
                    if (!(entity instanceof Fam)) continue;
                    Indi husband = ((Fam)entity).getHusband();
                    if (husband != null && this.isAlive(husband)) {
                        this.aliveEntities.add((Entity)husband);
                        this.aliveEntities.add(ent);
                        return true;
                    }
                    Indi wife = ((Fam)entity).getWife();
                    if (wife == null || !this.isAlive(wife)) continue;
                    this.aliveEntities.add((Entity)wife);
                    this.aliveEntities.add(ent);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isPrivateEvent(Property prop) {
        return false;
    }

    private boolean hasTagMarkingPrivate(Property prop) {
        if (this.getPropertyFor(prop, this.tagMarkingPrivate, Property.class) != null) {
            return true;
        }
        if ((prop = prop.getParent()) != null) {
            return this.hasTagMarkingPrivate(prop);
        }
        return false;
    }

    private boolean isInfoOfDeceased(Property prop) {
        Entity e = prop.getEntity();
        if (e instanceof Indi) {
            return ((Indi)e).isDeceased();
        }
        if (e instanceof Fam) {
            Indi husband = ((Fam)e).getHusband();
            if (husband != null && !husband.isDeceased()) {
                return false;
            }
            Indi wife = ((Fam)e).getWife();
            return wife != null && wife.isDeceased();
        }
        return false;
    }

    private boolean hasPrivateYearsDate(Property prop) {
        List dateProps = prop.getProperties(PropertyDate.class);
        for (PropertyDate propertyDate : dateProps) {
            if (!this.isDatePrivate(propertyDate)) continue;
            return true;
        }
        return false;
    }

    private boolean isDatePrivate(PropertyDate date) {
        if (date == null) {
            return false;
        }
        Delta anniversary = date.getAnniversary();
        return anniversary != null && anniversary.getYears() < this.yearsInfoIsPrivate;
    }

    private boolean isAlive(Indi indi) {
        PropertyDate bdate = indi.getBirthDate();
        PropertyDate ddate = indi.getDeathDate();
        if (bdate == null) {
            return false;
        }
        Delta anniversary = bdate.getAnniversary();
        return ddate == null && anniversary != null && anniversary.getYears() < this.yearsIndiCanBeAlive;
    }

    private List<Entity> getRelatedPeople(Entity ent) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        List refProps = ent.getProperties(PropertyXRef.class);
        for (PropertyXRef propertyXRef : refProps) {
            Entity target = propertyXRef.getTargetEntity().orElse(null);
            if (target == null || list.contains(target) || !(target instanceof Indi) && !(target instanceof Fam)) continue;
            list.add(target);
        }
        return list;
    }

    private Property getPropertyFor(Property prop, String tag, Class<?> type) {
        int j = prop.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property child = prop.getProperty(i);
            if (!child.getTag().equals(tag) || !type.isAssignableFrom(child.getClass())) continue;
            return child;
        }
        return null;
    }

    public Set<Entity> getCurrentPrivateEntities() {
        return this.privateYearsEntities;
    }
}

