/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.core.resources.Images;
import ancestris.view.SelectionDispatcher;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.LookupEvent;

public class DelProperty
extends AbstractChange {
    private Set<Property> candidates = new HashSet<Property>();

    public DelProperty() {
        this(new ArrayList<Property>());
    }

    public DelProperty(List<Property> props) {
        this.setContextProperties(props);
        this.setImageText(Images.imgDel, resources.getString("delete") + "...");
        this.contextChanged();
    }

    public void resultChanged(LookupEvent ev) {
        this.candidates.clear();
        this.candidates.addAll(this.lkpInfo.allInstances());
        super.resultChanged(ev);
    }

    protected final void contextChanged() {
        this.candidates.clear();
        this.candidates.addAll(this.contextProperties);
        this.setEnabled(!this.candidates.isEmpty());
        Object result = "";
        if (this.candidates != null && !this.candidates.isEmpty()) {
            result = this.candidates.size() > 1 ? Property.getPropertyNames(this.candidates, (int)5) + " (" + this.candidates.size() + ")" : this.candidates.iterator().next().toString();
        }
        this.setTip(resources.getString("delete.tip", new Object[]{result}));
    }

    @Override
    protected String getConfirmMessage() {
        StringBuilder txt = new StringBuilder();
        txt.append(resources.getString("confirm.del.props", new Object[]{this.candidates.size()}));
        txt.append("<br>");
        int i = 0;
        for (Property prop : this.candidates) {
            if (i++ > 16) {
                txt.append("...");
                break;
            }
            txt.append("&nbsp;&nbsp;&nbsp;&nbsp;&Bull;&nbsp;&nbsp;" + prop.toString() + " (" + prop.getPropertyName() + ")");
            txt.append("<br>");
        }
        return txt.toString();
    }

    @Override
    protected Context execute(Gedcom gedcom, ActionEvent event) throws GedcomException {
        HashSet<Entity> orphans = new HashSet<Entity>();
        Property parent = null;
        for (Property prop : new HashSet<Property>(this.candidates)) {
            if (prop instanceof Entity) {
                gedcom.deleteEntity((Entity)prop);
                continue;
            }
            if (prop instanceof PropertyXRef && prop.isValid()) {
                orphans.add((Entity)((PropertyXRef)prop).getTargetEntity().get());
                orphans.add(prop.getEntity());
            }
            parent = prop.getParent();
            parent.delProperty(prop);
        }
        for (Entity orphan : orphans) {
            if (orphan instanceof Indi || orphan.isConnected()) continue;
            gedcom.deleteEntity(orphan);
        }
        if (parent != null) {
            SelectionDispatcher.fireSelection((Context)new Context(parent));
        }
        return null;
    }
}

