/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openide.explorer.propertysheet.PSheet;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class DescriptionComponent
extends JComponent
implements ActionListener,
MouseListener,
Accessible {
    private static int fontHeight = -1;
    private JEditorPane jep;
    private JLabel lbl;
    private JButton btn;
    private JToolBar toolbar;
    private JScrollPane jsc;

    public DescriptionComponent() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jep = new JEditorPane();
        this.jep.setOpaque(false);
        this.jep.setBackground(this.getBackground());
        this.jep.setEditable(false);
        this.jep.setOpaque(false);
        this.jep.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DescriptionComponent.class, (String)"ACS_Description"));
        this.jep.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DescriptionComponent.class, (String)"ACSD_Description"));
        this.jep.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        if (htmlKit.getStyleSheet().getStyleSheets() == null) {
            StyleSheet css = new StyleSheet();
            Font f = new JLabel().getFont();
            css.addRule(new StringBuffer("body { font-size: ").append(f.getSize()).append("; font-family: ").append(f.getName()).append("; }").toString());
            css.addStyleSheet(htmlKit.getStyleSheet());
            htmlKit.setStyleSheet(css);
        } else {
            this.jep.setFont(new JLabel().getFont());
        }
        this.jep.setEditorKit(htmlKit);
        this.jsc = new JScrollPane(this.jep);
        this.jsc.setHorizontalScrollBarPolicy(31);
        this.jsc.setVerticalScrollBarPolicy(21);
        this.jsc.setBorder(BorderFactory.createEmptyBorder());
        this.jsc.setViewportBorder(this.jsc.getBorder());
        this.jsc.setOpaque(false);
        this.jsc.setBackground(this.getBackground());
        this.jsc.getViewport().setOpaque(false);
        if (!PropUtils.psNoHelpButton) {
            if (PropUtils.isAqua) {
                this.btn = new JButton();
                this.btn.addActionListener(this);
                this.btn.putClientProperty("JButton.buttonType", "help");
                this.btn.setOpaque(false);
                this.btn.setContentAreaFilled(false);
            } else {
                Image help = ImageUtilities.loadImage((String)"org/openide/resources/propertysheet/propertySheetHelp.png", (boolean)true);
                this.btn = new JButton(ImageUtilities.image2Icon((Image)help));
                this.btn.addActionListener(this);
                this.toolbar = new JToolBar();
                this.toolbar.setRollover(true);
                this.toolbar.setFloatable(false);
                this.toolbar.setLayout(new BorderLayout(0, 0));
                this.toolbar.setBorder(BorderFactory.createEmptyBorder());
                this.toolbar.setBorderPainted(false);
                this.toolbar.add(this.btn);
            }
            this.btn.setFocusable(false);
        }
        this.lbl = new JLabel("Label");
        this.lbl.setFont(new Font(null, 1, this.lbl.getFont().getSize()));
        this.add(this.jsc);
        this.add(this.lbl);
        if (!PropUtils.psNoHelpButton) {
            this.add(PropUtils.isAqua ? this.btn : this.toolbar);
        }
        this.jep.addMouseListener(this);
        this.jsc.addMouseListener(this);
        this.lbl.addMouseListener(this);
        if (!PropUtils.psNoHelpButton) {
            this.btn.addMouseListener(this);
        }
        this.jsc.getViewport().addMouseListener(this);
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        Dimension lbll = this.lbl.getPreferredSize();
        int height = lbll.height;
        int right = this.getWidth() - ins.right;
        if (!PropUtils.psNoHelpButton) {
            Dimension bttn = PropUtils.isAqua ? this.btn.getPreferredSize() : this.toolbar.getPreferredSize();
            height = Math.max(bttn.height, lbll.height);
            right = this.getWidth() - (ins.right + bttn.width);
            if (PropUtils.isAqua) {
                this.btn.setBounds(right, ins.top, bttn.width, height);
            } else {
                this.toolbar.setBounds(right, ins.top, bttn.width, height);
            }
        }
        this.lbl.setBounds(ins.left, ins.top, right, height);
        this.jsc.setBounds(ins.left, height, this.getWidth() - (ins.left + ins.right), this.getHeight() - height);
    }

    public void setDescription(String title, String txt) {
        if (title == null) {
            title = "";
        }
        if (txt == null) {
            txt = "";
        }
        this.lbl.setText(title);
        if (title.equals(txt)) {
            this.jep.setText("");
        } else {
            this.jep.setText(txt);
        }
    }

    public void setHelpEnabled(boolean val) {
        if (!PropUtils.psNoHelpButton) {
            this.btn.setEnabled(val);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (fontHeight == -1) {
            fontHeight = g.getFontMetrics(this.lbl.getFont()).getHeight();
        }
        super.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(super.getPreferredSize());
        if (fontHeight > 0) {
            Insets ins = this.getInsets();
            d.height = Math.max(50, Math.max(d.height, 4 * fontHeight + ins.top + ins.bottom + 12));
        } else {
            d.height = Math.min(d.height, 64);
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        if (fontHeight < 0) {
            return super.getMinimumSize();
        }
        Dimension d = new Dimension(4 * fontHeight, 4 * fontHeight);
        return d;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PSheet sheet = (PSheet)SwingUtilities.getAncestorOfClass(PSheet.class, this);
        if (sheet != null) {
            sheet.helpRequested();
        }
    }

    private PSheet findSheet() {
        return (PSheet)SwingUtilities.getAncestorOfClass(PSheet.class, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        PSheet sh = this.findSheet();
        if (sh != null) {
            sh.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        PSheet sh = this.findSheet();
        if (sh != null) {
            sh.mousePressed(e);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (null == this.accessibleContext) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.SWING_COMPONENT;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(DescriptionComponent.class, (String)"ACS_Description"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(DescriptionComponent.class, (String)"ACSD_Description"));
        }
        return this.accessibleContext;
    }
}

