/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Grammar;
import genj.gedcom.TagPath;

public class Submitter
extends Entity {
    private static final TagPath PATH_NAME = new TagPath("SUBM:NAME");
    private static final TagPath PATH_ADDR = new TagPath("SUBM:ADDR");
    private static final TagPath PATH_CITY = new TagPath("SUBM:ADDR:CITY");
    private static final TagPath PATH_STAE = new TagPath("SUBM:ADDR:STAE");
    private static final TagPath PATH_POST = new TagPath("SUBM:ADDR:POST");
    private static final TagPath PATH_CTRY = new TagPath("SUBM:ADDR:CTRY");
    private static final TagPath PATH_PHON = new TagPath("SUBM:PHON");
    private static final String TAG_SUBM = "SUBM:";
    private static final String TAG_EMAI = "EMAIL";
    private static final String TAG_WEB = "WWW";

    public Submitter(String tag, String id) {
        super(tag, id);
        this.assertTag("SUBM");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void moveEntityValue() {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.getName().isEmpty()) {
                this.setName(value);
                this.setValue("");
            } else {
                super.moveEntityValue();
            }
        }
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getName();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    @Override
    public String getDisplayTitle(boolean showIds) {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getName().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = "?";
        }
        if (showIds) {
            return this.getId() + " - " + str;
        }
        return str;
    }

    public String getName() {
        return this.getValue(PATH_NAME, "");
    }

    public void setName(String name) {
        this.setValue(PATH_NAME, name);
    }

    public String getAddress() {
        return this.getValue(PATH_ADDR, "");
    }

    public void setAddress(String name) {
        this.setValue(PATH_ADDR, name);
    }

    public String getCity() {
        return this.getValue(PATH_CITY, "");
    }

    public void setCity(String name) {
        this.setValue(PATH_CITY, name);
    }

    public String getState() {
        return this.getValue(PATH_STAE, "");
    }

    public void setState(String name) {
        this.setValue(PATH_STAE, name);
    }

    public String getPostcode() {
        return this.getValue(PATH_POST, "");
    }

    public void setPostcode(String name) {
        this.setValue(PATH_POST, name);
    }

    public String getCountry() {
        return this.getValue(PATH_CTRY, "");
    }

    public void setCountry(String name) {
        this.setValue(PATH_CTRY, name);
    }

    public String getPhone() {
        return this.getValue(PATH_PHON, "");
    }

    public void setPhone(String name) {
        this.setValue(PATH_PHON, name);
    }

    public String getEmail() {
        return this.getValue(new TagPath(this.getPrefix(TAG_EMAI)), "");
    }

    public void setEmail(String name) {
        this.setValue(new TagPath(this.getPrefix(TAG_EMAI)), name);
    }

    public String getWeb() {
        return this.getValue(new TagPath(this.getPrefix(TAG_WEB)), "");
    }

    public void setWeb(String name) {
        this.setValue(new TagPath(this.getPrefix(TAG_WEB)), name);
    }

    private String getPrefix(String str) {
        return TAG_SUBM + (Grammar.V55.equals(this.getGedcom().getGrammar()) ? "_" : "") + str;
    }
}

