/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.models.FamiliesTableModel;
import genj.gedcom.Property;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import genj.util.ReferenceSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class GedcomPlaceTableModel
extends AbstractTableModel {
    ReferenceSet<String, Property> mGedcomPlacesMap = new ReferenceSet();
    String[] placeFormat;

    public GedcomPlaceTableModel(String[] placeFormat) {
        this.placeFormat = placeFormat;
    }

    @Override
    public int getRowCount() {
        return this.mGedcomPlacesMap.getKeys().size();
    }

    @Override
    public int getColumnCount() {
        return this.placeFormat.length + 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object[] toArray = this.mGedcomPlacesMap.getKeys().toArray();
        String key = (String)toArray[row];
        if (column < this.placeFormat.length) {
            if (key.split(",").length > column) {
                return key.split(",")[column];
            }
            return "";
        }
        Set references = this.mGedcomPlacesMap.getReferences((Object)key);
        if (((PropertyPlace)references.toArray()[0]).getMap() != null) {
            if (column < this.placeFormat.length + 1) {
                PropertyLatitude latitude = ((PropertyPlace)references.toArray()[0]).getLatitude(true);
                return latitude != null ? latitude.getValue() : "";
            }
            PropertyLongitude longitude = ((PropertyPlace)references.toArray()[0]).getLongitude(true);
            return longitude != null ? longitude.getValue() : "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.placeFormat.length) {
            return this.placeFormat[col];
        }
        if (col < this.placeFormat.length + 1) {
            return NbBundle.getMessage(FamiliesTableModel.class, (String)"GedcomPlaceTableModel.column.latitude.title");
        }
        return NbBundle.getMessage(FamiliesTableModel.class, (String)"GedcomPlaceTableModel.column.longitude.title");
    }

    public void update(ReferenceSet<String, Property> gedcomPlacesMap) {
        List refSetKeys = gedcomPlacesMap.getKeys();
        for (String refSetKey : refSetKeys) {
            Set references = gedcomPlacesMap.getReferences((Object)refSetKey);
            for (Property reference : references) {
                Object key = refSetKey;
                if (((PropertyPlace)reference).getMap() != null) {
                    PropertyLongitude longitude;
                    PropertyLatitude latitude = ((PropertyPlace)reference).getLatitude(true);
                    if (latitude != null) {
                        key = (String)key + "," + latitude.getValue();
                    }
                    if ((longitude = ((PropertyPlace)reference).getLongitude(true)) != null) {
                        key = (String)key + "," + longitude.getValue();
                    }
                }
                this.mGedcomPlacesMap.add(key, (Object)reference);
            }
        }
        this.fireTableDataChanged();
    }

    public Set<Property> getValueAt(int row) {
        Object[] toArray = this.mGedcomPlacesMap.getKeys().toArray();
        String key = (String)toArray[row];
        return this.mGedcomPlacesMap.getReferences((Object)key);
    }
}

