/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.searchdupes.DuplicatesResults;
import ancestris.modules.gedcom.searchdupes.DuplicatesTaskMatchesForAllEntities;
import ancestris.modules.gedcom.searchdupes.SearchDuplicatesPanel;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.PotentialMatch;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.openide.util.NbBundle;

public final class SearchDuplicatesAction
extends AbstractAncestrisContextAction {
    public SearchDuplicatesAction() {
        this.setIconBase("ancestris/modules/gedcom/searchdupes/CheckDuplicateIcon.png");
        this.setText(NbBundle.getMessage(SearchDuplicatesAction.class, (String)"CTL_CheckDuplicatesAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            Gedcom gedcom = contextToOpen.getGedcom();
            JButton OKButton = new JButton(NbBundle.getMessage(SearchDuplicatesAction.class, (String)"ok_button"));
            SearchDuplicatesPanel searchDuplicatesSpecsPanel = new SearchDuplicatesPanel(gedcom, OKButton);
            Object o = DialogManager.create((String)(NbBundle.getMessage(SearchDuplicatesAction.class, (String)"CTL_CheckDuplicatesAction").replaceAll("&", "") + " - " + gedcom.getDisplayName()), (JComponent)searchDuplicatesSpecsPanel).setMessageType(-1).setOptions(new Object[]{OKButton, DialogManager.CANCEL_OPTION}).setDialogId("duplicateWindow").show();
            if (o != OKButton) {
                return;
            }
            List<String> entities2Check = searchDuplicatesSpecsPanel.getEntitiesToCheck();
            Map<String, MatcherOptions> selectedOptions = searchDuplicatesSpecsPanel.getSelectedOptions();
            boolean excludedNonDup = searchDuplicatesSpecsPanel.getNonDupExclusion();
            DuplicatesTaskMatchesForAllEntities mainTask = new DuplicatesTaskMatchesForAllEntities(gedcom, entities2Check, selectedOptions, excludedNonDup);
            mainTask.run();
            List<PotentialMatch<? extends Entity>> matchesLinkedList = mainTask.getResult();
            TreeMap<String, EntityMatcher> entitiesMatchers = mainTask.getEntityMatchers();
            DuplicatesResults results = new DuplicatesResults(gedcom, matchesLinkedList);
            results.setEntities2Check(entities2Check);
            results.setEntitiesMatchers(entitiesMatchers);
            results.show();
        }
    }
}

